#include "BLEDevice.h"

uint8_t uuid_array_service[16]   = {'b', 'f', 't', 'j', ' ', 'i', 'r', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
uint8_t uuid_array_header[16]    = {'b', 'f', 't', 'j', ' ', 'i', 'r', ' ', 'h', 'e', 'a', 'd', 'e', 'r', ' ', ' '};
uint8_t uuid_array_one[16]       = {'b', 'f', 't', 'j', ' ', 'i', 'r', ' ', 'o', 'n', 'e', ' ', ' ', ' ', ' ', ' '};
uint8_t uuid_array_zero[16]      = {'b', 'f', 't', 'j', ' ', 'i', 'r', ' ', 'z', 'e', 'r', 'o', ' ', ' ', ' ', ' '};
uint8_t uuid_array_ptrail[16]    = {'b', 'f', 't', 'j', ' ', 'i', 'r', ' ', 'p', 't', 'r', 'a', 'i', 'l', ' ', ' '};
uint8_t uuid_array_predata[16]   = {'b', 'f', 't', 'j', ' ', 'i', 'r', ' ', 'p', 'r', 'e', 'd', 'a', 't', 'a', ' '};
uint8_t uuid_array_code[16]      = {'b', 'f', 't', 'j', ' ', 'i', 'r', ' ', 'c', 'o', 'd', 'e', ' ', ' ', ' ', ' '};

const UUID uuid_service = UUID(uuid_array_service);
const UUID uuid_header = UUID(uuid_array_header);
const UUID uuid_one = UUID(uuid_array_one);
const UUID uuid_zero = UUID(uuid_array_zero);
const UUID uuid_ptrail = UUID(uuid_array_ptrail);
const UUID uuid_predata = UUID(uuid_array_predata);
const UUID uuid_code = UUID(uuid_array_code);

uint8_t header_data[4];
uint16_t header_data_length = 4;
uint8_t one_data[4];
uint16_t one_data_length = 4;
uint8_t zero_data[4];
uint16_t zero_data_length = 4;
uint8_t ptrail_data[2];
uint16_t ptrail_data_length = 2;
uint8_t predata_data[2];
uint16_t predata_data_length = 2;
uint8_t code_data[2];
uint16_t code_data_length = 2;

GattCharacteristic header = GattCharacteristic(uuid_header, header_data, sizeof(header_data), sizeof(header_data), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);
GattCharacteristic one = GattCharacteristic(uuid_one, one_data, sizeof(one_data), sizeof(one_data), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);
GattCharacteristic zero = GattCharacteristic(uuid_zero, zero_data, sizeof(zero_data), sizeof(zero_data), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic ptrail = GattCharacteristic(uuid_ptrail, ptrail_data, sizeof(ptrail_data), sizeof(ptrail_data), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic predata = GattCharacteristic(uuid_predata, predata_data, sizeof(predata_data), sizeof(predata_data), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
GattCharacteristic code = GattCharacteristic(uuid_code, code_data, sizeof(code_data), sizeof(code_data), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);

GattCharacteristic *characteristics[] = {&header, &one, &zero, &ptrail, &predata, &code};
GattService ir_service = GattService(uuid_service, characteristics, sizeof(characteristics) / sizeof(GattCharacteristic *));