#include "mbed.h"

#ifndef QNODE_H
#define QNODE_H

typedef struct QNode{
    uint8_t uid[4];
    struct QNode *next;
} QNode;

// The queue, front stores the front node of LL and rear stores ths
// last node of LL
struct Queue
{
    struct QNode *front, *rear;
};


struct QNode* newNode(uint8_t* k);
struct Queue *createQueue();
void enQueue(struct Queue *q, uint8_t *k);
struct QNode *deQueue(struct Queue *q);


#endif