// eeprom.cpp file
#include "eeprom.h"



void freq(uint32_t frec)
{
    i2c.frequency(frec);
}

int write_data(uint8_t eepr_addr, uint16_t address, uint8_t *ptr_string)
{
    wait_ms(4);
    i2c.start();
    int ack=i2c.write(eepr_addr<<1);
    if(ack==1) {
        i2c.write(address<<8);
        i2c.write(address);
        for(int i =0; i<4 ;i++) {
            i2c.write(ptr_string[i]);
        }
        i2c.stop();
        return 1;//success
    } else if(ack==0) {
        return 0;//NACK
    } else if(ack==2) {
        return 2;//TIMEOUT
    }
    return -1;
}


uint8_t data_read(uint8_t eepr_addr, uint16_t address_read)
{
    wait_ms(5);
    uint8_t read;
    i2c.start();
    int ack=i2c.write(eepr_addr<<1);
    //pc.printf("ack= %d \n",ack);
    if(ack==1) {
        i2c.write(address_read<<8);
        i2c.write(address_read);
        i2c.start();
        i2c.write(eepr_addr<<1|0x01);
        read=i2c.read(0);
        i2c.stop();
        return read;
    }
    return -1;
}
