#include "mbed.h"
#include "MFRC522.h"
#include "qnode.h"
#include "Buffer.h"


DigitalOut led_3(LED3);
DigitalOut led2(LED2);
DigitalOut LedGreen(LED1);
DigitalOut enable(p19);
Serial pc(USBTX, USBRX);
Serial disp_uno(p9, p10);  // tx, rx
MFRC522    RfChip   (p5, p6, p7, p8, p21);
circular_buf_t buf; // ---->BUFFER CIRCULAR buf
bool flag1=false;
bool flag2=false;
bool flag3=false;
volatile bool buf1ready=false;
volatile bool buf2ready=false;


void disp_unoTx_isr()
{
    enable=0;
}

void disp_unoRx_isr()
{
    led2=1;
    uint8_t b = disp_uno.getc();

    if(b!=NULL) {
        circular_buf_put(&buf, b);
    } else {
        uint8_t a;
        circular_buf_get(&buf,&a);
        if(a=='1') {
            circular_buf_get(&buf,&a);
            if(a=='S') {
                flag1=true;
            } else if(a=='Y') {
                flag2=true;
            } else if(a=='N') {
                flag3=true;
            }
        }else
        circular_buf_reset(&buf);

    }

}


int main()
{
    struct Queue *q = createQueue();
    pc.printf("Listo para lectura\n");
    buf.size = 5;
    buf.buffer = (uint8_t*) malloc(buf.size);
    enable=0;
    led2=0;
    RfChip.PCD_Init();
    disp_uno.attach(&disp_unoRx_isr,Serial::RxIrq);
    disp_uno.attach(&disp_unoTx_isr,Serial::TxIrq);

    while(1) {
        led2 = !led2;
        wait_ms(5);
        if ( RfChip.PICC_IsNewCardPresent()) {
            led_3=0;
            if (RfChip.PICC_ReadCardSerial()) {
                LedGreen = 1;
                pc.printf("Tarjeta Numero: ");
                uint8_t * c = &RfChip.uid.uidByte[0];
                enQueue(q,c);
                pc.printf("\n\r");
                wait_ms(200);
            }
        }


        if(flag1==true) {
            QNode *c= deQueue(q);
            enable=1;
            for(int i=0; i<4; i++) {
                disp_uno.printf("%02X ",c->uid[i]);
            }
            enable=1;
            disp_uno.putc('\n');
            flag1=false;
        } else if(flag2==true) {
            //enable=1;
            pc.printf("YES\n");
            flag2=false;
        } else if(flag3==true) {
            //enable=1;
            pc.printf("NO\n");
            flag3=false;
        }

    }
}
