#include "mover.h"
#include "main.h"
#include "mbed.h"
#include "math.h"

//indicamos la variables de salidas de señales PWM para cada uno de los servos.

PwmOut myServo1(PB_10);
PwmOut myServo2(PA_8);
PwmOut myServo3(PA_9);
PwmOut myServo4(PC_7);
PwmOut myServo5(PB_6);
PwmOut myServo6(PA_7);
PwmOut myServo7(PA_6);
PwmOut myServo8(PA_5);


uint8_t  ss_time=50;     // variable de tiempo  de espera para moverse 1 mm en microsegundos

void put_sstime(uint8_t vtime){
    ss_time=vtime;
}

int coord2us(float coord){                // asignacion de formula general para obtener la equivalencia de 0 a 180° y 1 a 2 ms para mover el servo (regla de tres)
    if(0 <= coord <= MAXPOS)
        return int(750+coord*1900/180);// valor indicado de retorno
        return 750;
}


void mover_ser(uint8_t motores, uint8_t posicion){ //se agregan los datos de "nmotor" y "grados" y se almacenan en "motor" y "pos".

    int pulseX = coord2us(posicion); //se asigna la vaiable "pulseX" y se le carga el valor obtenido de la formula general obtenida en "coord2us"
    switch (motores){ //se realiza un caso switch con la variable asignada para seleccionar qué motor mover
        
        case 0x01: {
            myServo1.pulsewidth_us(pulseX); //al motor seleccionado se le asigna y se le indica el ancho de pulso almacenado en la variable "pulseX" para que se mueva a la posición seleccinada
            break;
            }
            
        case 0x02: {
            myServo2.pulsewidth_us(pulseX);
            break;
            }
            
        case 0x03:{
            myServo3.pulsewidth_us(pulseX);
            break;
            }
            
        case 0x04:{
            myServo4.pulsewidth_us(pulseX);
            break;
            }
            
        case 0x05:{
            myServo5.pulsewidth_us(pulseX);
            break;
            }
            
        case 0x06:{
            myServo6.pulsewidth_us(pulseX);
            break;
            }
            
        case 0x07:{
            myServo7.pulsewidth_us(pulseX);
            break;
            }
            
        case 0x08:{
                myServo8.pulsewidth_us(pulseX);
                break;
                }     
            
        default: break;
        }
}


void mover_conjunto(uint8_t motores, uint8_t posicion){


    if (posicion==0xDD){//patas adelante
    
    switch(motores){
        case 1:{
            myServo2.pulsewidth_us(2800);
            
            debug_m("Mover pata 1, adelante. \n");
            break;
            }
            
        case 2:{
            
            myServo4.pulsewidth_us(2800);
            debug_m("Mover pata 2, adelante.  \n");
             break ;
            }
        
        case 3:{
            
            myServo6.pulsewidth_us(550);
            debug_m("Mover pata 3, adelante. . \n");
            break;
            }
        
        case 4:{
            myServo8.pulsewidth_us(700);
            debug_m("Mover pata 4, adelante.  \n");
            break;
            }
        
        default: {
            debug_m("Motores no definidos. \n");
            }
         }
     }
     
     else{
     if (posicion==0xDA){
    
    switch(motores){
        case 1:{
            myServo2.pulsewidth_us(550);
            debug_m("Mover pata 1, atras.  \n");
            break;
            }
            
        case 2:{
                        myServo4.pulsewidth_us(550);
            debug_m("Mover pata 2, atras.  \n");
            break;
            }
        
        case 3:{
            
            myServo6.pulsewidth_us(2800);
            debug_m("Mover pata 3, atras.  \n");
            break;
            }
        
        case 4:{
           
            myServo8.pulsewidth_us(2800);
           debug_m("Mover pata 4, atras. \n");
            break;
            }
        
        default: {
            debug_m("Motores no definidos. \n");
            }
         }
     }
     
     
     else{
     
     if (posicion==0x1D){
    
    switch(motores){
        case 1:{
            myServo1.pulsewidth_us(550);
            
            debug_m("Mover pata 1, arriba.  \n");
            break;
            }
            
        case 2:{
            myServo3.pulsewidth_us(550);
            
            debug_m("Mover pata 2, arriba. \n");
            break;
            }
        
        case 3:{
            myServo5.pulsewidth_us(550);
            
           debug_m("Mover pata 3, arriba. \n");
            break;
            }
        
        case 4:{
            myServo7.pulsewidth_us(550);
            
            debug_m("Mover pata 4, arriba. \n");
            break;
            }
        
        default: {
            debug_m("Motores no definidos. \n");
            }
         }
     }
     else{
     if (posicion==0x1A){
    
    switch(motores){
        case 1:{
            myServo1.pulsewidth_us(1500);
           
            debug_m("\nMover pata 1, abajo.\n");
            break;
            }
            
        case 2:{
            myServo3.pulsewidth_us(1300);
            
            debug_m("\nMover pata 2, abajo. \n");
            break;
            }
        
        case 3:{
            myServo5.pulsewidth_us(1500);
            
            debug_m("Mover pata 3, abajo. \n");
            break;
            }
        
        case 4:{
            myServo7.pulsewidth_us(1500);
            
           debug_m("Mover pata 4, abajo. \n");
            break;
            }
        
        default: {
            debug_m("Motores no definidos. \n");
            }
         }
     }
     
     else{
         debug_m("Movimiento no definido. \n");
         
         }
         }
         }
         }
    wait_ms (700);   
    debug_m("\n           ******fin mover conjunto de motores.****** \n\n");
    }
void iniciando_(){
    myServo1.pulsewidth_us(1500);//1
    wait_ms(100);
    myServo3.pulsewidth_us(1300);
    wait_ms(100);
    myServo5.pulsewidth_us(1500);
    wait_ms(100);
    myServo7.pulsewidth_us(1500);//1
    wait_ms(100);
    myServo1.pulsewidth_us(550);//2
    wait_ms(100);
    myServo2.pulsewidth_us(1150);
    wait_ms(500);
    myServo2.pulsewidth_us(2200);
    wait_ms(500);
    myServo2.pulsewidth_us(1700);
    wait_ms(100);
    myServo1.pulsewidth_us(1500);//2
    wait_ms(500);
    myServo3.pulsewidth_us(550);//3
    wait_ms(100);
    myServo4.pulsewidth_us(1150);
    wait_ms(500);
    myServo4.pulsewidth_us(2200);
    wait_ms(500);
    myServo4.pulsewidth_us(1700);
    wait_ms(100);  
    myServo3.pulsewidth_us(1300);//3*****************1500
    wait_ms(500);
    myServo5.pulsewidth_us(550);//4
    wait_ms(100);
     myServo6.pulsewidth_us(1150);
    wait_ms(500);
    myServo6.pulsewidth_us(2200);
    wait_ms(500);
    myServo6.pulsewidth_us(1700);
    wait_ms(100);
    myServo5.pulsewidth_us(1500);//4
    wait_ms(500);
    myServo7.pulsewidth_us(550);//5
    wait_ms(100);
    myServo8.pulsewidth_us(1150);
    wait_ms(500);
    myServo8.pulsewidth_us(2200);
    wait_ms(500);
    myServo8.pulsewidth_us(1700);
    wait_ms(100);
    myServo7.pulsewidth_us(1500);//5
    wait_ms(50);
        }
void adelante_(){
    myServo1.pulsewidth_us(1500);//1
    myServo5.pulsewidth_us(1500);
    
    myServo2.pulsewidth_us(800);
    myServo3.pulsewidth_us(550);
    myServo4.pulsewidth_us(2800);
    wait(0.1);
    myServo3.pulsewidth_us(1300);
    wait(0.1);
    myServo4.pulsewidth_us(1700);///////////////////
    //wait(0.3);    
    myServo1.pulsewidth_us(550);
    myServo2.pulsewidth_us(1700);
    wait(0.1);  
    myServo1.pulsewidth_us(1500); 
    wait(0.1);                      //1
    
    myServo7.pulsewidth_us(550);
    myServo6.pulsewidth_us(2800);
    myServo8.pulsewidth_us(750);
    wait(0.1);
    myServo7.pulsewidth_us(1500);
    wait(0.1);     
    myServo8.pulsewidth_us(1700);
    myServo5.pulsewidth_us(550);
    myServo6.pulsewidth_us(1700);
    wait(0.1);
    myServo5.pulsewidth_us(1500);
    
    /*wait(1);
    myServo8.pulsewidth_us(1800);
    wait(1);
    myServo7.pulsewidth_us(1200);
    wait(1);*/
    }
    
void atras_(){
    
    myServo1.pulsewidth_us(1500);//1
    myServo3.pulsewidth_us(1300);
    myServo5.pulsewidth_us(1500);
    myServo7.pulsewidth_us(1500);
    
    myServo4.pulsewidth_us(2800);
    myServo1.pulsewidth_us(550);
    myServo2.pulsewidth_us(800);
    wait(0.1);
    myServo1.pulsewidth_us(1500);
    wait(0.1);
    myServo2.pulsewidth_us(1700);///////////////////
    //wait(0.3);    
    myServo3.pulsewidth_us(550);
    myServo4.pulsewidth_us(1700);
    wait(0.1);  
    myServo3.pulsewidth_us(1300); 
    wait(0.1);                      //1

    myServo5.pulsewidth_us(550);
    myServo8.pulsewidth_us(800);
    myServo6.pulsewidth_us(2800);
    wait(0.1);
    myServo5.pulsewidth_us(1500);
    wait(0.1);     
    myServo6.pulsewidth_us(1700);
    myServo7.pulsewidth_us(550);
    myServo8.pulsewidth_us(1700);
    wait(0.1);
    myServo7.pulsewidth_us(1500);
   
}
void derecha_(){
    myServo2.pulsewidth_us(700);
    myServo7.pulsewidth_us(550);
    myServo8.pulsewidth_us(700);
    wait(0.3);
    myServo7.pulsewidth_us(1300);
    wait(0.3);
    myServo8.pulsewidth_us(1300);
    myServo1.pulsewidth_us(1300);
    myServo7.pulsewidth_us(550);
    myServo8.pulsewidth_us(700);
    wait(0.3);
    myServo7.pulsewidth_us(1300);
    myServo8.pulsewidth_us(550);
    wait(1);
    myServo2.pulsewidth_us(1700);
    wait(0.3);
    myServo4.pulsewidth_us(1700);
    myServo6.pulsewidth_us(1700);
    myServo8.pulsewidth_us(1700);
    }
void izquierda_(){
   
    //myServo7.pulsewidth_us(2200);
      //      myServo8.pulsewidth_us(2500);
    }
void mover_frenteanalog(){adelante_();}
void mover_atrasanalog(){atras_();}
void init_servo() //se configura el periodo de los servos
{
   myServo1.period_ms(20);
   myServo2.period_ms(20);
   myServo3.period_ms(20);
   myServo4.period_ms(20);
   myServo5.period_ms(20);
   myServo6.period_ms(20);
   myServo7.period_ms(20);
   myServo8.period_ms(20);

    
}