#include "mbed.h"
#include "C12832.h"
#include "Arial12x12.h"
#include "Arial_9.h"
#include "Small_7.h"
#include "Small_6.h"

Serial pc(USBTX, USBRX);
C12832 lcd(p5, p7, p6, p8, p11);
AnalogIn Pot1(p19);
AnalogIn Pot2(p20);
PwmOut spkr(p26);
PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);
BusOut leds(LED1,LED2,LED3,LED4);
Timer timer1;
InterruptIn joystickcenter(p14);
InterruptIn button(p9);
float force, temperature;
float Process_Force=4700.0;      // Process parameters can be modified depending on the product. Force of sealing
float Process_Temperature=230.0; // Process parameters can be modified depending on the product. Temperature of sealing
float Cycle_time=5.0;            // Process parameters can be modified depending on the product. Time of sealing.
int k,v;

// HMI function. Interface to control and initiate the system
void HMI(){
   
    pc.printf("HEAT SEAL OPERATION\n TO START OPERATION PRESS 's'\n FOR SET UP PRESS 'p'");
    lcd.locate(10,0);
    lcd.set_font((unsigned char*)Arial12x12);
    lcd.printf("HEAT SEAL\n");
    char c = pc.getc();
    
    if(c=='s'){
            timer1.start(); // start timer1 counting
            pc.printf("CYLCE STARTED\n");
            lcd.locate(85,0);
            lcd.set_font((unsigned char*)Small_7);
            lcd.printf("STARTED\n");
            }
    if(c=='p') {
            pc.printf("SYSTEM READY\n");
            lcd.locate(85,0);
            lcd.set_font((unsigned char*)Small_7);
            lcd.printf("READY!!\n");   
    }    
}

//Cycle within specs
void good(){
    leds=0xf;
    wait(0.5);
    leds=!leds;
}

//Cycle out of Specs
void bad(){
    spkr.period(5.0/2000);
    spkr=(0.5);
    wait(0.5);
    spkr=0.0;
}

// Joystick centre button. Activates the Emergency stop. System require Reset after E-stop activated.
void flip() {
    timer1.stop();
    pc.printf("CYLCE STOPPED\n");
    lcd.locate(85,0);
    lcd.set_font((unsigned char*)Small_7);
    lcd.printf("STOPPED\n");
    r.period(0.001);
    g=1;
    r=0;
    wait(2);
    timer1.reset();
}

  
// HEAT SEAL OPERATION    
int main(){
    
    k=1;
    v=1;
    HMI();
    joystickcenter.rise(&flip); 
    button.mode(PullUp);
    button.rise(&flip);
    
    while(1){
        
        r=b=1;
        force=Pot1*5500;
        temperature=Pot2*300+30;
        lcd.locate(0,12);
        lcd.set_font((unsigned char*)Small_7);
        lcd.printf("Force=%.1fN\n",force);
        lcd.locate(70,12);
        lcd.set_font((unsigned char*)Small_7);
        lcd.printf("Temp=%.1fC\n",temperature);
        
        if(force>=Process_Force && temperature>=Process_Temperature && timer1.read()>=Cycle_time){
            good();
            lcd.locate(15,24);
            lcd.set_font((unsigned char*)Small_6);
            lcd.printf("Pass=%d\n",k);
            k++;
            timer1.reset(); 
        }
        else if(timer1.read()>=5.0){
            bad();
            lcd.locate(70,24);
            lcd.set_font((unsigned char*)Small_6);
            lcd.printf("Fail=%d\n",v);
            v++;
            timer1.reset();
        }        
    }        
}    