#include "mbed.h"
#include "TFC.h"


//This macro is to maintain compatibility with Codewarrior version of the sample.   This version uses the MBED libraries for serial port access
Serial PC(USBTX,USBRX);

#define TERMINAL_PRINTF     PC.printf


//This ticker code is used to maintain compability with the Codewarrior version of the sample.   This code uses an MBED Ticker for background timing.

#define NUM_TFC_TICKERS 4

Ticker TFC_TickerObj;

volatile uint32_t TFC_Ticker[NUM_TFC_TICKERS];

void TFC_TickerUpdate()
{
    int i;

    for(i=0; i<NUM_TFC_TICKERS; i++) {
        if(TFC_Ticker[i]<0xFFFFFFFF) {
            TFC_Ticker[i]++;
        }
    }
}

int main2()
{
    PC.baud(115200);
    TFC_TickerObj.attach_us(&TFC_TickerUpdate,2000);

    TFC_Init();
    //TFC_SetMotorPWM(0,0);
    for(;;) {

    }
}

int mainTestCamera()
{
    uint32_t i,t = 0;

    PC.baud(115200);
    TFC_TickerObj.attach_us(&TFC_TickerUpdate,2000);

    TFC_Init();

    for(;;) {
        if(TFC_Ticker[0]>1000 && TFC_LineScanImageReady>0) {
            TFC_Ticker[0] = 0;
            TFC_LineScanImageReady = 0;
            // camera 1
            for(i=0; i<128; i++) {
                TERMINAL_PRINTF("%X,",TFC_LineScanImage0[i]);
            }
            TERMINAL_PRINTF("\r\n");
        }
    }

}


int mainTestServo()
{
    uint32_t i,t = 0;

    PC.baud(115200);
    TFC_TickerObj.attach_us(&TFC_TickerUpdate,2000);

    TFC_Init();
    float val = -1;       //-0.4 is all the way to the right. 0.4 is all the way to the left
    TFC_SetServo(0,val);
    for(;;) {
        val+= 0.5;
        if(val>1) {
            val = -1;
        }
        TFC_SetServo(0,val);
        wait(1);
    }
}

int main()
{
    PC.baud(115200);
    TFC_TickerObj.attach_us(&TFC_TickerUpdate,2000);
    TFC_Init();
    for(;;) {
        PC.printf("Select component to test:\r\n0: Servos\r\n1: Motors\r\n2: Camera (CCD1)\r\n");
        switch(PC.getc()) {
            default:
            case '0':
                PC.printf("Testing Servos. Restart the board to stop.\r\n");
                float val = -1;       //-0.4 is all the way to the right. 0.4 is all the way to the left
                TFC_SetServo(0,val);
                while(1) {
                    val+= 0.5;
                    if(val>1) {
                        val = -1;
                    }
                    TFC_SetServo(0,val);
                    wait(1);
                }
                break;
            case '1' :
                PC.printf("Testing Motors. Restart the board to stop.\r\n");
                PC.printf("Enter value between -1 and 1. Format: +xx.xx (must include +/- sign)\r\n");
                char inString[7];
                PC.gets(inString, 7);
                PC.printf(inString);
                PC.printf("\r\n");
                float duty = atof(inString);
                TFC_SetMotorPWM(duty,duty);
                while(1) {
                    PC.printf("Enter value between -1 and 1. Format: +xx.xx (must include +/- sign)\r\n");
                    PC.gets(inString, 7);
                    PC.printf(inString);
                    PC.printf("\r\n");
                    duty = atof(inString);
                    TFC_SetMotorPWM(duty,duty);
                }
                break;
            case '2' :
                PC.printf("Testing Camera. Restart the board to stop.\r\n");
                int t = 0;
                while(1)
                {
                    if(TFC_Ticker[0]>50 && TFC_LineScanImageReady>0)
                    {
                        TFC_Ticker[0] = 0;
                        TFC_LineScanImageReady=0;
                        TERMINAL_PRINTF("\r\n");
                        TERMINAL_PRINTF("L:");
                        if(t==0)
                        {
                            t=4;
                        }else{
                            t--;
                            
                            // camera 1
                            for(int i=0; i<128; i++) {
                                TERMINAL_PRINTF("%X,",TFC_LineScanImage0[i]);
                            }
                        }
                    }

                }
                break;
        }
    }


}

