#include "mbed.h"

//Just a couple of the outputs directly accessible for debug
DigitalIn O0(p14);/*
DigitalIn O1(p15);
DigitalIn O2(p16);
DigitalIn O3(p20);*/
DigitalIn O4(p19);/*
DigitalIn O5(p18);
DigitalIn O6(p17);
DigitalIn O7(p21);*/

DigitalOut CE(p22);
DigitalOut OE(p24);

Serial pc(USBTX, USBRX);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
BusIn epromdata(p14,p15,p16,p20,p19,p18,p17,p21);
BusOut addressline(p13,p12,p11,p10,p9,p8,p7,p6,p27,p26,p23,p25,p5,p28);


int main() {
    //CE and OE lines are inverted
    CE=1;
    OE=1;
    //Give me some time to set up a pipe into a file
    wait(8);
    
    int num=16384; //number of addresses
    char epromcontents[num]; //char array to store data words
    for (int addr=0;addr<num;addr++){
        addressline=addr; //set the address
        CE=0;//clock the chip
        OE=0;
        wait(1e-6); //wait a generous 1000ns
        epromcontents[addr]=epromdata.read(); //then read the data into the array
        //just as a sanity check, send two of the data lines to LEDs 1 and 2
        led1=O0;
        led2=O4;
        //bring the clock lines back up and wait for the output to go back into tristated mode        
        CE=1;
        OE=1;
        wait(1e-6);
        
    }
    //led3 goes on to say we're done
    led3=1;
for(int i=0;i<num;i++)
pc.printf("%d\n",epromcontents[i]);//send each byte over usbserial
led4=1;//to say we're done sending
}

