
/** \addtogroup rtos */
/** @{*/
/* mbed Microcontroller Library
 * Copyright (c) 2006-2012 ARM Limited
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#ifndef RTOS_H
#define RTOS_H

#include "rtos/Thread.h"
#include "rtos/Mutex.h"
#include "rtos/RtosTimer.h"
#include "rtos/Semaphore.h"
#include "rtos/Mail.h"
#include "rtos/MemoryPool.h"
#include "rtos/Queue.h"

using namespace rtos;

/* Get mbed lib version number, as RTOS depends on mbed lib features
   like mbed_error, Callback and others.
*/
#include "mbed.h"

#if (MBED_LIBRARY_VERSION < 122)
#error "This version of RTOS requires mbed library version > 121"
#endif

#endif

/** @}*/
