#include "mbed.h"

#include "draw.h"
#define CM_EJECUTAR 0xff
#define CM_GUARDAR 0xfe
#define CM_VERTEX2D 0xfd
#define CM_DRAW 0xfc
#define CM_NODRAW 0xfb
#define CM_STOP 0xfa
#define CM_END 0xf0
#define MEM_TYPE uint32_t
#define MAXPOS 50       
#define POSDRAW 10 
#define ss_time 100 
#include "math.h"




void ejecutar(){
    command.printf("se esta ejecutando el dibujo..."); 
     
  
    PwmOut myServoX(PB_3);
    PwmOut myServoY(PB_4);
    PwmOut myServoZ(PB_5);
   
    
    uint32_t  posx_old=0;     // posición anterior del eje X
    uint32_t  posy_old=0;     // posición anterior del eje Y
    uint32_t  ss_time=100;     // tiempo  de espera para moverse 1 mm en microsegundos 
    
    void  put_sstime(uint32_t vtime)
    {
        s_time = vtime;
    }
    
    int coord2us(float coord);
    {
    if(0 <= coord <= MAXPOS)
    return int(750+coord*1900/50);// u6
    return 750;
    }
 
   void sstime(uint32_t x, uint32_t y)
    {
        double dx=abs(x-posx_old);
        double dy=abs(y-posy_old);
        double dist= sqrt(dx*dx+dy*dy);
        wait_ms((int)(ss_time*dist));
        posx_old =x;
        posy_old=y;    
    }
 
    void vertex2d(uint32_t x, uint32_t y)
    { 
    int pulseX = coord2us(x);
    int pulseY = coord2us(y);
    
        myServoX.pulsewidth_us(pulseX);
        myServoY.pulsewidth_us(pulseY);
        sstime(x,y); 
    }
   
   void  home () 
   {
        nodraw ();
        vertex2d ( 0,0 );
    }    
    
    void  draw () ;
    {
        myServoZ.pulsewidth_us (POSDRAW);
        wait_ms (ss_time * 2 );
    }
 
    void  nodraw () ;
    {
        myServoZ.pulsewidth_us (MAXPOS);
        wait_ms (ss_time * 2 );
    }
    void  initdraw ( float  x,  fLoat  y) ;
    {
        vertex2d (x, y);
        dibujar();
    } 
    void  init_servo ();
    {
        myServoX.period_ms ( 20 );
        myServoY.period_ms ( 20 );
         myServoZ.period_ms ( 20 );
    }

 }
 










void guardar(){
    command.printf("se inicia el comado de guardar..");    
    // ubicar acà el codigo
    int mem_head = 0;
int mem_tail = 0;
uint32_t full = 0;
 
MEM_TYPE buffer[MEM_SIZE];
Serial command(USBTX, USBRX); 
 
uint32_t mem_free()
{
 mem_head=0;
 full=0;
}
 
uint32_t mem_put(MEM_TYPE data)
{
 
    if (full)
        return 1;
    buffer[mem_head] = data;
    mem_head += 1;
    if (mem_head == MEM_SIZE)
        full =1;
    return 0;
}
uint32_t mem_get(MEM_TYPE* data)
{
    if (mem_head == 0)
        return 1; 
    if (mem_head == mem_tail)
        return 1; 
    
 
    *data = buffer[mem_tail];
    mem_tail += 1;
  
    return 0;
}
 
int main(){
    
    mem_put(command.getc());
    mem_put(command.getc());
    mem_put(command.getc());
    mem_put(command.getc());
    MEM_TYPE val;
    mem_get(&val);
    command.putc(val);
    }
}







void init_serial()
{
    Serial command(USBTX, USBRX);
    command.baud(9600);    
    pc.format(8,none,1);
}
int main() {
    init_servo();
    init_serial();
    home();
    char read_cc;
    while(1)
    {
        switch (read_cc) {
            case  CM_EJECUTAR: ejecutar(); break;
            case  CM_GUARDAR: guardar(); break;
            default: command.printf("error de comando");break ;      
        }
    }
}
