#include "SAFETY.h"

#define USR_POWERDOWN   (0x104)

// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
void SAFETY::kick(void)
{
    LPC_WDT->WDFEED = 0xAA;
    LPC_WDT->WDFEED = 0x55;
}

void SAFETY::kick(float s)
{
    LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
    uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
    LPC_WDT->WDTC = s * (float)clk;
    LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
    kick();
}

int SAFETY::semihost_powerdown()
{
    uint32_t arg;
    return __semihost(USR_POWERDOWN, &arg);
}

void SAFETY::init(uint32_t brownOutRoutine)
{
    //Power Down Ethernet
    PHY_PowerDown();
    //Power Down USB Chip
    semihost_powerdown();
    //Setup Brown Out Interrupt
    NVIC_SetVector(BOD_IRQn, brownOutRoutine);
    //Enable Brown Out Interrupt
    NVIC_EnableIRQ(BOD_IRQn);
}