#ifndef LOCALIZE_H
#define LOCALIZE_H

#include "mbed.h"
#include "BNO055.h"

#define R_P_ADDR    0x04
//0x0B^0x0F=0x04
#define R_N_ADDR    0x0B

#define FRAME_H     180
#define FRAME_W     150
#define R_WAIT      0.075
#define R_ERROR     14
#define RX_OFF      7
#define RY_OFF      6

#define ERROR_IMU   -1
#define ERROR_RX_P  -2
#define ERROR_RX_N  -3
#define ERROR_RY_P  -4
#define ERROR_RY_N  -5

typedef struct {
    int x;
    int y;
    int a;
}LOCALIZE_xya;

class LOCALIZE
{
public:
    LOCALIZE(I2C& y_i2c, I2C& x_imu_i2c, PinName imu_reset);
    int init(void);
    void get_raw_xy(void);
    void get_angle(LOCALIZE_xya *xya);
    void get_xy(LOCALIZE_xya *xya);

protected:
    int _angle, _rx_p, _rx_n, _ry_p, _ry_n;
    I2C _y_i2c;
    I2C _x_imu_i2c;
    BNO055 _imu;
    BNO055_EULER_TypeDef _euler;
    BNO055_GRAVITY_TypeDef _gravity;
    BNO055_LIN_ACC_TypeDef _accel;
    LOCALIZE_xya _xya;
};

#endif  //LOCALIZE_H