#include "LOCALIZE.h"

LOCALIZE::LOCALIZE (I2C& y_i2c, I2C& x_imu_i2c, PinName imu_reset):
    _y_i2c(y_i2c), _x_imu_i2c(x_imu_i2c), _imu(x_imu_i2c, imu_reset) {}

int LOCALIZE::init (void)
{
    if(_imu.chip_ready()==0)
        return ERROR_IMU;
    _imu.set_mounting_position(MT_P0);
    _imu.change_fusion_mode(MODE_IMU);
    char data[]= {0,0,0};
    if(_x_imu_i2c.read(R_P_ADDR<<1, data, 3)!=0)
        return ERROR_RX_P;
    if(_x_imu_i2c.read(R_N_ADDR<<1, data, 3)!=0)
        return ERROR_RX_N;
    if(_y_i2c.read(R_P_ADDR<<1, data, 3)!=0)
        return ERROR_RY_P;
    if(_y_i2c.read(R_N_ADDR<<1, data, 3)!=0)
        return ERROR_RY_N;
    return 0;
}

void LOCALIZE::get_angle(LOCALIZE_xya *xya)
{
    _imu.get_Euler_Angles(&_euler);
    _imu.get_gravity(&_gravity);
    unsigned int quad=0;
    if(_gravity.y>=0)
        quad&=~1;
    else
        quad|=1;
    if(_gravity.x>=0)
        quad&=~(1<<1);
    else
        quad|=(1<<1);
    quad&=3;
    switch(quad) {
        case 0:
            _angle=_euler.p;
            break;
        case 1:
            _angle=180-_euler.p;
            break;
        case 2:
            _angle=360+_euler.p;
            break;
        case 3:
            _angle=180+abs(_euler.p);
            break;
        default:
            _angle=-1;
            break;
    }
    _xya.a=_angle;
    xya->a=_xya.a;
}

void LOCALIZE::get_xy(LOCALIZE_xya *xya)
{
    int _rx, _ry;
    get_raw_xy();
    get_angle(xya);
    if(_xya.a<R_ERROR || _xya.a>360-R_ERROR) {
        _rx=_rx_p<_rx_n ? _rx_p : FRAME_W-RX_OFF-_rx_n;
        _ry=_ry_p<_ry_n ? _ry_p : FRAME_H-RY_OFF-_ry_n;
    } else if(abs(_xya.a-90)<R_ERROR) {
        _rx=_ry_p<_ry_n ? _ry_p : FRAME_W-RY_OFF-_ry_n;
        _ry=_rx_p<_rx_n ? FRAME_H-RX_OFF-_rx_p : _rx_n;
    } else if(abs(_xya.a-180)<R_ERROR) {
        _rx=_rx_p<_rx_n ? FRAME_W-RX_OFF-_rx_p : _rx_n;
        _ry=_ry_p<_ry_n ? FRAME_H-RY_OFF-_ry_p : _ry_n;
    } else if(abs(_xya.a-270)<R_ERROR) {
        _rx=_ry_p<_ry_n ? FRAME_W-RY_OFF-_ry_p : _ry_n;
        _ry=_rx_p<_rx_n ? _rx_p : FRAME_H-RX_OFF-_rx_n; 
    } else {
        //error
        _rx=_rx_p;
        _ry=_ry_p;
    }
    _xya.x=_rx;
    _xya.y=_ry;
    xya->x=_xya.x;
    xya->y=_xya.y;
}

void LOCALIZE::get_raw_xy(void)
{
    char data[]= {0,0,0};
    _x_imu_i2c.read(R_P_ADDR<<1, data, 3);
    wait(R_WAIT);
    _rx_p=data[1];
    _x_imu_i2c.read(R_N_ADDR<<1, data, 3);
    wait(R_WAIT);
    _rx_n=data[1];
    _y_i2c.read(R_P_ADDR<<1, data, 3);
    wait(R_WAIT);
    _ry_p=data[1];
    _y_i2c.read(R_N_ADDR<<1, data, 3);
    wait(R_WAIT);
    _ry_n=data[1];
    //printf("%d %d %d %d\n",_rx_p,_rx_n,_ry_p,_ry_n);
}