#include "mbed.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "rtos.h"
#define X 0x000000
#define _ 0xFFFFFF
#define MONSTER_HEIGHT 24
#define MONSTER_WIDTH 33

uLCD_4DGL uLCD(p28, p27, p26);
SDFileSystem sd(p5, p6, p7, p8, "sd");
AnalogOut DACout(p18);
wave_player waver(&DACout);
FILE *fp;
FILE *wave_file;
int menu_state;
bool arrow_state;
bool light_state; // 0: on 1: off
int info_state;

class Nav_Switch
{
public:
    Nav_Switch(PinName up,PinName down,PinName left,PinName right,PinName fire);
    int read();
//boolean functions to test each switch
    bool up();
    bool down();
    bool left();
    bool right();
    bool fire();
//automatic read on RHS
    operator int ();
//index to any switch array style
    bool operator[](int index) {
        return _pins[index];
    };
private:
    BusIn _pins;
 
};
Nav_Switch::Nav_Switch (PinName up,PinName down,PinName left,PinName right,PinName fire):
    _pins(up, down, left, right, fire)
{
    _pins.mode(PullUp); //needed if pullups not on board or a bare nav switch is used - delete otherwise
    wait(0.001); //delays just a bit for pullups to pull inputs high
}
inline bool Nav_Switch::up()
{
    return !(_pins[0]);
}
inline bool Nav_Switch::down()
{
    return !(_pins[1]);
}
inline bool Nav_Switch::left()
{
    return !(_pins[2]);
}
inline bool Nav_Switch::right()
{
    return !(_pins[3]);
}
inline bool Nav_Switch::fire()
{
    return !(_pins[4]);
}
inline int Nav_Switch::read()
{
    return _pins.read();
}
inline Nav_Switch::operator int ()
{
    return _pins.read();
}
 
Nav_Switch myNav( p12, p15, p14, p16, p13);

// draw start

int FOOD[22*17]={
    _,_,_,_,_,_,_,X,X,X,X,X,X,X,X,_,_,_,_,_,_,_,
    _,_,_,_,_,_,X,X,_,_,_,_,_,_,X,X,_,_,_,_,_,_,
    _,_,_,_,_,X,X,_,_,_,_,_,_,_,_,X,X,_,_,_,_,_,
    _,_,_,_,X,X,_,_,_,_,_,_,_,_,_,_,X,X,_,_,_,_,
    _,_,_,X,X,_,_,_,_,_,_,_,_,_,_,_,_,X,X,_,_,_,
    _,_,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,_,_,
    _,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,_,
    X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,
    X,X,_,_,_,_,X,X,X,X,X,X,X,X,X,X,_,_,_,_,X,X,
    X,X,_,_,_,_,X,X,X,X,X,X,X,X,X,X,_,_,_,_,X,X,
    X,X,_,_,_,_,X,X,X,X,X,X,X,X,X,X,_,_,_,_,X,X,
    X,X,_,_,_,_,X,X,X,X,X,X,X,X,X,X,_,_,_,_,X,X,
    X,X,_,_,_,_,X,X,X,X,X,X,X,X,X,X,_,_,_,_,X,X,
    X,X,_,_,_,_,X,X,X,X,X,X,X,X,X,X,_,_,_,_,X,X,
    X,X,_,_,_,_,X,X,X,X,X,X,X,X,X,X,_,_,_,_,X,X,
    _,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,
    _,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,
};

int FOOD2[22*6]={
    X,X,_,_,_,_,X,X,X,X,X,X,X,X,X,X,_,_,_,_,X,X,
    X,X,_,_,_,_,X,X,X,X,X,X,X,X,X,X,_,_,_,_,X,X,
    X,X,_,_,_,_,X,X,X,X,X,X,X,X,X,X,_,_,_,_,X,X,
    X,X,_,_,_,_,X,X,X,X,X,X,X,X,X,X,_,_,_,_,X,X,
    _,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,
    _,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,
};

int MED[16*16]={
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
    X,X,_,_,_,_,_,_,_,_,_,_,_,_,X,X,
    X,X,_,_,_,_,_,X,X,_,_,_,_,_,X,X,
    X,X,_,_,_,_,_,X,X,_,_,_,_,_,X,X,
    X,X,_,_,_,_,_,X,X,_,_,_,_,_,X,X,
    X,X,_,_,_,_,_,X,X,_,_,_,_,_,X,X,
    X,X,_,X,X,X,X,X,X,X,X,X,X,_,X,X,
    X,X,_,X,X,X,X,X,X,X,X,X,X,_,X,X,
    X,X,_,_,_,_,_,X,X,_,_,_,_,_,X,X,
    X,X,_,_,_,_,_,X,X,_,_,_,_,_,X,X,
    X,X,_,_,_,_,_,X,X,_,_,_,_,_,X,X,
    X,X,_,_,_,_,_,X,X,_,_,_,_,_,X,X,
    X,X,_,_,_,_,_,_,_,_,_,_,_,_,X,X,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
};

int MED2[16*8]={
    X,X,_,X,X,X,X,X,X,X,X,X,X,_,X,X,
    X,X,_,_,_,_,_,X,X,_,_,_,_,_,X,X,
    X,X,_,_,_,_,_,X,X,_,_,_,_,_,X,X,
    X,X,_,_,_,_,_,X,X,_,_,_,_,_,X,X,
    X,X,_,_,_,_,_,X,X,_,_,_,_,_,X,X,
    X,X,_,_,_,_,_,_,_,_,_,_,_,_,X,X,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
};


int POOP[8*11]={
    _,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,X,_,_,_,_,_,
    _,_,_,_,_,X,X,_,_,_,_,
    _,_,_,_,X,X,X,X,_,_,_,
    _,_,_,X,X,X,_,X,_,_,_,
    _,_,X,X,X,X,X,_,X,_,_,
    _,X,X,X,X,X,X,X,X,X,_,
};

int MONSTER1_1[MONSTER_HEIGHT * MONSTER_WIDTH]={
    _,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,
    _,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,
    _,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,
    X,X,X,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,
    X,X,X,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,
    X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,_,_,_,
    X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,_,_,_,
    X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,_,_,_,
    X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,_,_,_,
    X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,_,_,_,
    X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,_,_,_,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
    _,_,_,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,
    _,_,_,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,
    _,_,_,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,
    _,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,
    _,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,
    _,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,
    _,_,_,_,_,_,_,_,_,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,_,_,_,_,_,_,_,_,_,
};

int MONSTER1_2[MONSTER_HEIGHT * MONSTER_WIDTH]={
    _,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,X,X,X,
    _,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,X,X,X,
    _,_,_,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,
    _,_,_,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,
    _,_,_,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,
    _,_,_,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,
    _,_,_,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,
    _,_,_,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
    X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,_,_,_,
    X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,_,_,_,
    X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,_,_,_,
    X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,
    X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,
    X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,_,_,_,_,_,_,_,_,_,
};


int MONSTER1_MAD1[MONSTER_HEIGHT * MONSTER_WIDTH]={
    _,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,_,_,_,
    _,_,_,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,_,_,_,
    _,_,_,_,_,_,X,X,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,X,X,_,_,_,_,_,_,
    X,X,X,X,X,X,X,X,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,X,X,X,X,X,X,X,X,
    X,X,X,X,X,X,X,X,X,_,_,X,X,X,X,X,X,X,X,X,X,X,_,_,X,X,X,X,X,X,X,X,X,
    X,X,X,X,X,X,X,X,X,X,_,_,X,X,X,X,X,X,X,X,X,_,_,X,X,X,X,X,X,X,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
    X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,
    X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,
    X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,
    X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,
    X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,
    X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,
    _,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,
    _,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,
    _,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,
};





int MONSTER1_SICK1[MONSTER_HEIGHT * MONSTER_WIDTH]={
    _,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,
    _,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,
    _,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,_,_,_,
    _,_,_,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,_,_,_,
    _,_,_,_,_,_,X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,
    _,_,_,X,X,X,X,X,_,X,_,X,_,X,X,X,X,X,X,X,_,X,_,X,_,X,X,X,X,X,_,_,_,
    _,_,_,X,X,X,X,X,_,_,X,_,_,X,X,X,X,X,X,X,_,_,X,_,_,X,X,X,X,X,_,_,_,
    _,_,_,X,X,X,X,X,_,X,_,X,_,X,X,X,X,X,X,X,_,X,_,X,_,X,X,X,X,X,_,_,_,
    X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
    X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,
    X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,
    X,X,X,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,X,X,X,
    X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,
    X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,
    X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,
    _,_,_,_,_,_,_,_,_,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,X,X,X,_,_,_,X,X,X,X,X,X,_,_,_,_,_,_,_,_,_,
};

int MONSTER1_SLEEP1[MONSTER_HEIGHT * MONSTER_WIDTH]={
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,X,X,X,_,X,X,X,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,_,_,_,X,_,_,_,X,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,X,X,X,_,X,X,X,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,X,X,X,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,_,_,_,
    _,_,_,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,_,_,_,
    _,_,_,_,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,_,_,_,
    _,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,X,X,X,X,X,X,X,_,_,_,
    _,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,
    _,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,
};

void drawMenu1(int color) {
    uLCD.line(12, 6, 13, 6, color);
    uLCD.line(24, 6, 25, 6, color);
    uLCD.line(13, 7, 14, 7, color);
    uLCD.line(23, 7, 25, 7, color);
    uLCD.line(10, 8, 11, 8, color);
    uLCD.line(14, 8, 15, 8, color);
    uLCD.line(22, 8, 25, 8, color);
    uLCD.line(8, 9, 9, 9, color);
    uLCD.line(11, 9, 13, 9, color);
    uLCD.line(15, 9, 16, 9, color);
    uLCD.line(21, 9, 25, 9, color);
    uLCD.line(9, 10, 10, 10, color);
    uLCD.line(12, 10, 14, 10, color);
    uLCD.line(15, 10, 16, 10, color);
    uLCD.line(20, 10, 25, 10, color);
    uLCD.line(10, 11, 11, 11, color);
    uLCD.line(13, 11, 16, 11, color);
    uLCD.line(19, 11, 24, 11, color);
    uLCD.line(11, 12, 16, 12, color);
    uLCD.line(18, 12, 23, 12, color);
    uLCD.line(12, 13, 15, 13, color);
    uLCD.line(17, 13, 22, 13, color);
    uLCD.line(16, 14, 21, 14, color);
    uLCD.line(15, 15, 18, 15, color);
    uLCD.line(14, 16, 17, 16, color);
    uLCD.line(19, 16, 21, 16, color);
    uLCD.line(13, 17, 16, 17, color);
    uLCD.line(18, 17, 22, 17, color);
    uLCD.line(11, 18, 15, 18, color);
    uLCD.line(19, 18, 23, 18, color);
    uLCD.line(11, 19, 14, 19, color);
    uLCD.line(20, 19, 24, 19, color);
    uLCD.line(9, 20, 13, 20, color);
    uLCD.line(21, 20, 25, 20, color);
    uLCD.line(10, 21, 12, 21, color);
    uLCD.line(22, 21, 25, 21, color);
}

void drawMenu2(int color) {
    uLCD.line(44, 5, 45, 5, color);
    uLCD.line(53, 5, 54, 5, color);
    uLCD.line(45, 6, 46, 6, color);
    uLCD.line(52, 6, 53, 6, color);
    uLCD.line(45, 7, 46, 7, color);
    uLCD.line(52, 7, 53, 7, color);
    uLCD.line(47, 8, 51, 8, color);
    uLCD.line(42, 9, 43, 9, color);
    uLCD.line(45, 9, 50, 9, color);
    uLCD.line(51, 9, 53, 9, color);
    uLCD.line(55, 9, 56, 9, color);
    uLCD.line(45, 10, 51, 10, color);
    uLCD.line(52, 10, 53, 10, color);
    uLCD.line(44, 11, 52, 11, color);
    uLCD.line(53, 11, 54, 11, color);
    uLCD.line(44, 12, 52, 12, color);
    uLCD.line(53, 12, 54, 12, color);
    uLCD.line(40, 13, 43, 13, color);
    uLCD.line(44, 13, 54, 13, color);
    uLCD.line(55, 13, 58, 13, color);
    uLCD.line(44, 14, 54, 14, color);
    uLCD.line(45, 15, 53, 15, color);
    uLCD.line(43, 16, 44, 16, color);
    uLCD.line(45, 16, 53, 16, color);
    uLCD.line(54, 16, 55, 16, color);
    uLCD.line(41, 17, 42, 17, color);
    uLCD.line(46, 17, 52, 17, color);
    uLCD.line(56, 17, 57, 17, color);
    uLCD.line(46, 18, 52, 18, color);
    uLCD.line(47, 19, 51, 19, color);
    uLCD.line(47, 21, 51, 21, color);
    uLCD.line(47, 22, 51, 22, color);
}

void drawMenu3(int color) {
    uLCD.line(73, 4, 74, 4, color);
    uLCD.line(72, 5, 76, 5, color);
    uLCD.line(71, 6, 77, 6, color);
    uLCD.line(71, 7, 78, 7, color);
    uLCD.line(72, 8, 79, 8, color);
    uLCD.line(73, 9, 79, 9, color);
    uLCD.line(74, 10, 80, 10, color);
    uLCD.line(75, 11, 81, 11, color);
    uLCD.line(76, 12, 82, 12, color);
    uLCD.line(77, 13, 83, 13, color);
    uLCD.line(79, 14, 83, 14, color);
    uLCD.line(80, 15, 84, 15, color);
    uLCD.line(82, 16, 85, 16, color);
    uLCD.line(83, 17, 86, 17, color);
    uLCD.line(84, 18, 86, 18, color);
    uLCD.line(85, 19, 87, 19, color);
    uLCD.line(74, 20, 76, 20, color);
    uLCD.line(86, 20, 88, 20, color);
    uLCD.line(73, 21, 76, 21, color);
    uLCD.line(87, 21, 89, 21, color);
    uLCD.line(73, 22, 76, 22, color);
    uLCD.line(88, 22, 90, 22, color);
}

void drawMenu4(int color) {
    uLCD.line(106, 4, 110, 4, color);
    uLCD.line(104, 5, 106, 5, color);
    uLCD.line(110, 5, 112, 5, color);
    uLCD.line(104, 6, 105, 6, color);
    uLCD.line(111, 6, 113, 6, color);
    uLCD.line(103, 7, 104, 7, color);
    uLCD.line(112, 7, 114, 7, color);
    uLCD.line(103, 8, 104, 8, color);
    uLCD.line(113, 8, 115, 8, color);
    uLCD.line(103, 9, 104, 9, color);
    uLCD.line(114, 9, 116, 9, color);
    uLCD.line(103, 10, 104, 10, color);
    uLCD.line(115, 10, 117, 10, color);
    uLCD.line(104, 11, 105, 11, color);
    uLCD.line(116, 11, 118, 11, color);
    uLCD.line(104, 12, 106, 12, color);
    uLCD.line(115, 12, 119, 12, color);
    uLCD.line(105, 13, 107, 13, color);
    uLCD.line(114, 13, 120, 13, color);
    uLCD.line(106, 14, 108, 14, color);
    uLCD.line(113, 14, 121, 14, color);
    uLCD.line(107, 15, 109, 15, color);
    uLCD.line(112, 15, 122, 15, color);
    uLCD.line(108, 16, 109, 16, color);
    uLCD.line(111, 16, 122, 16, color);
    uLCD.line(109, 17, 122, 17, color);
    uLCD.line(110, 18, 122, 18, color);
    uLCD.line(111, 19, 122, 19, color);
    uLCD.line(112, 20, 122, 20, color);
    uLCD.line(113, 21, 122, 21, color);
    uLCD.line(114, 22, 121, 22, color);
}

void drawMenu5(int color) {
    uLCD.line(20, 107, 24, 107, color);
    uLCD.line(19, 108, 25, 108, color);
    uLCD.line(18, 109, 25, 109, color);
    uLCD.line(18, 110, 25, 110, color);
    uLCD.line(17, 111, 25, 111, color);
    uLCD.line(17, 112, 24, 112, color);
    uLCD.line(17, 113, 24, 113, color);
    uLCD.line(18, 114, 23, 114, color);
    uLCD.line(11, 115, 18, 115, color);
    uLCD.line(21, 115, 22, 115, color);
    uLCD.line(10, 116, 11, 116, color);
    uLCD.line(18, 116, 21, 116, color);
    uLCD.line(9, 117, 11, 117, color);
    uLCD.line(17, 117, 21, 117, color);
    uLCD.line(11, 118, 21, 118, color);
    uLCD.line(10, 119, 11, 119, color);
    uLCD.line(16, 119, 20, 119, color);
    uLCD.line(11, 120, 20, 120, color);
    uLCD.line(12, 121, 19, 121, color);
    uLCD.line(12, 122, 13, 122, color);
    uLCD.line(14, 122, 19, 122, color);
    uLCD.line(12, 123, 19, 123, color);
    uLCD.line(12, 124, 19, 124, color);
}

void drawMenu6(int color) {
    uLCD.line(46, 107, 50, 107, color);
    uLCD.line(46, 108, 51, 108, color);
    uLCD.line(45, 109, 51, 109, color);
    uLCD.line(46, 110, 51, 110, color);
    uLCD.line(48, 111, 49, 111, color);
    uLCD.line(46, 113, 53, 113, color);
    uLCD.line(46, 114, 53, 114, color);
    uLCD.line(46, 115, 51, 115, color);
    uLCD.line(46, 116, 51, 116, color);
    uLCD.line(46, 117, 51, 117, color);
    uLCD.line(46, 118, 51, 118, color);
    uLCD.line(46, 119, 51, 119, color);
    uLCD.line(46, 120, 51, 120, color);
    uLCD.line(46, 121, 51, 121, color);
    uLCD.line(46, 122, 51, 122, color);
    uLCD.line(44, 123, 53, 123, color);
    uLCD.line(44, 124, 53, 124, color);
}

void drawMenu7(int color) {
    uLCD.line(89, 108, 90, 108, color);
    uLCD.line(89, 109, 90, 109, color);
    uLCD.line(77, 110, 81, 110, color);
    uLCD.line(85, 110, 88, 110, color);
    uLCD.line(89, 110, 90, 110, color);
    uLCD.line(76, 111, 77, 111, color);
    uLCD.line(83, 111, 88, 111, color);
    uLCD.line(89, 111, 90, 111, color);
    uLCD.line(76, 112, 77, 112, color);
    uLCD.line(80, 112, 88, 112, color);
    uLCD.line(89, 112, 90, 112, color);
    uLCD.line(76, 113, 88, 113, color);
    uLCD.line(89, 113, 90, 113, color);
    uLCD.line(71, 114, 73, 114, color);
    uLCD.line(74, 114, 88, 114, color);
    uLCD.line(89, 114, 90, 114, color);
    uLCD.line(71, 115, 73, 115, color);
    uLCD.line(74, 115, 88, 115, color);
    uLCD.line(89, 115, 90, 115, color);
    uLCD.line(71, 116, 73, 116, color);
    uLCD.line(74, 116, 88, 116, color);
    uLCD.line(89, 116, 90, 116, color);
    uLCD.line(71, 117, 73, 117, color);
    uLCD.line(74, 117, 88, 117, color);
    uLCD.line(89, 117, 90, 117, color);
    uLCD.line(72, 118, 73, 118, color);
    uLCD.line(75, 118, 88, 118, color);
    uLCD.line(89, 118, 90, 118, color);
    uLCD.line(78, 119, 88, 119, color);
    uLCD.line(89, 119, 90, 119, color);
    uLCD.line(81, 120, 88, 120, color);
    uLCD.line(89, 120, 90, 120, color);
    uLCD.line(85, 121, 88, 121, color);
    uLCD.line(89, 121, 90, 121, color);
    uLCD.line(89, 122, 90, 122, color);
    uLCD.line(89, 123, 90, 123, color);
}

void drawMenu8(int color) {
    uLCD.line(103, 108, 106, 108, color);
    uLCD.line(112, 108, 114, 108, color);
    uLCD.line(103, 109, 107, 109, color);
    uLCD.line(112, 109, 115, 109, color);
    uLCD.line(103, 110, 108, 110, color);
    uLCD.line(112, 110, 117, 110, color);
    uLCD.line(103, 111, 110, 111, color);
    uLCD.line(112, 111, 118, 111, color);
    uLCD.line(103, 112, 111, 112, color);
    uLCD.line(112, 112, 119, 112, color);
    uLCD.line(103, 113, 121, 113, color);
    uLCD.line(103, 114, 122, 114, color);
    uLCD.line(103, 115, 122, 115, color);
    uLCD.line(103, 116, 122, 116, color);
    uLCD.line(103, 117, 122, 117, color);
    uLCD.line(103, 118, 120, 118, color);
    uLCD.line(103, 119, 111, 119, color);
    uLCD.line(112, 119, 119, 119, color);
    uLCD.line(103, 120, 110, 120, color);
    uLCD.line(112, 120, 118, 120, color);
    uLCD.line(103, 121, 108, 121, color);
    uLCD.line(112, 121, 117, 121, color);
    uLCD.line(103, 122, 107, 122, color);
    uLCD.line(112, 122, 115, 122, color);
    uLCD.line(103, 123, 106, 123, color);
    uLCD.line(112, 123, 114, 123, color);
}

void drawUpperFrame() {
    uLCD.filled_rectangle(0, 0, 127, 25, GREEN);
}

void drawMiddleFrame() {
    uLCD.filled_rectangle(0, 26, 127, 127-25+1, WHITE);
}

void drawLowerFrame() {
    uLCD.filled_rectangle(0, 127-25, 127, 127, GREEN);
}

void drawUpperMenu() {
    drawMenu1(0xA0A0A0);
    drawMenu2(0xA0A0A0);
    drawMenu3(0xA0A0A0);
    drawMenu4(0xA0A0A0);
}

void drawLowerMenu() {
    drawMenu5(0xA0A0A0);
    drawMenu6(0xA0A0A0);
    drawMenu7(0xA0A0A0);
    drawMenu8(0xA0A0A0);
}

void drawBackground() {
    drawUpperFrame();
    drawMiddleFrame();
    drawLowerFrame();
    drawUpperMenu();
    drawLowerMenu();
}

void clearMiddle() {
    uLCD.filled_rectangle(0, 25, 127, 127-25+1, WHITE);
}

void turnOffLight() {
    uLCD.filled_rectangle(0, 25, 127, 127-25+1, BLACK);
}

void drawArrow1(int color) {
    uLCD.line(18, 39, 20, 39, color);
    uLCD.line(18, 40, 21, 40, color);
    uLCD.line(18, 41, 22, 41, color);
    uLCD.line(19, 42, 23, 42, color);
    uLCD.line(20, 43, 24, 43, color);
    uLCD.line(9, 44, 25, 44, color);
    uLCD.line(8, 45, 25, 45, color);
    uLCD.line(8, 46, 25, 46, color);
    uLCD.line(9, 47, 25, 47, color);
    uLCD.line(20, 48, 24, 48, color);
    uLCD.line(19, 49, 23, 49, color);
    uLCD.line(18, 50, 22, 50, color);
    uLCD.line(18, 51, 21, 51, color);
    uLCD.line(18, 52, 20, 52, color);
}

void drawArrow2(int color) {
    uLCD.line(18, 72, 20, 72, color);
    uLCD.line(18, 73, 21, 73, color);
    uLCD.line(18, 74, 22, 74, color);
    uLCD.line(19, 75, 23, 75, color);
    uLCD.line(20, 76, 24, 76, color);
    uLCD.line(9, 77, 25, 77, color);
    uLCD.line(8, 78, 25, 78, color);
    uLCD.line(8, 79, 25, 79, color);
    uLCD.line(9, 80, 25, 80, color);
    uLCD.line(20, 81, 24, 81, color);
    uLCD.line(19, 82, 23, 82, color);
    uLCD.line(18, 83, 22, 83, color);
    uLCD.line(18, 84, 21, 84, color);
    uLCD.line(18, 85, 20, 85, color);
}

void displayOption2() {
    clearMiddle();
    uLCD.text_width(4); // 4 times
    uLCD.text_height(4);
    
    uLCD.locate(1, 1);
    uLCD.printf("ON");
    uLCD.locate(1, 2);
    uLCD.printf("OFF");
    
    if (arrow_state == 0) {
        drawArrow2(WHITE);
        drawArrow1(BLACK);
    } else {
        drawArrow1(WHITE);
        drawArrow2(BLACK);
    }
}

void drawRock(int color, int x) {
    uLCD.line(33, 35+x, 34, 35+x, color);
uLCD.line(31, 36+x, 35, 36+x, color);
uLCD.line(31, 37+x, 35, 37+x, color);
uLCD.line(33, 38+x, 35, 38+x, color);
uLCD.line(28, 39+x, 32, 39+x, color);
uLCD.line(36, 39+x, 39, 39+x, color);
uLCD.line(27, 40+x, 34, 40+x, color);
uLCD.line(36, 40+x, 39, 40+x, color);
uLCD.line(26, 41+x, 35, 41+x, color);
uLCD.line(37, 41+x, 39, 41+x, color);
uLCD.line(25, 42+x, 31, 42+x, color);
uLCD.line(32, 42+x, 36, 42+x, color);
uLCD.line(24, 43+x, 30, 43+x, color);
uLCD.line(33, 43+x, 37, 43+x, color);
uLCD.line(39, 43+x, 41, 43+x, color);
uLCD.line(24, 44+x, 30, 44+x, color);
uLCD.line(34, 44+x, 37, 44+x, color);
uLCD.line(38, 44+x, 42, 44+x, color);
uLCD.line(24, 45+x, 30, 45+x, color);
uLCD.line(32, 45+x, 33, 45+x, color);
uLCD.line(38, 45+x, 42, 45+x, color);
uLCD.line(24, 46+x, 30, 46+x, color);
uLCD.line(36, 46+x, 40, 46+x, color);
uLCD.line(24, 47+x, 31, 47+x, color);
uLCD.line(32, 47+x, 33, 47+x, color);
uLCD.line(35, 47+x, 39, 47+x, color);
uLCD.line(24, 48+x, 30, 48+x, color);
uLCD.line(32, 48+x, 34, 48+x, color);
uLCD.line(35, 48+x, 38, 48+x, color);
uLCD.line(40, 48+x, 43, 48+x, color);
uLCD.line(23, 49+x, 30, 49+x, color);
uLCD.line(32, 49+x, 34, 49+x, color);
uLCD.line(39, 49+x, 43, 49+x, color);
uLCD.line(22, 50+x, 30, 50+x, color);
uLCD.line(31, 50+x, 35, 50+x, color);
uLCD.line(37, 50+x, 42, 50+x, color);
uLCD.line(21, 51+x, 29, 51+x, color);
uLCD.line(31, 51+x, 35, 51+x, color);
uLCD.line(37, 51+x, 41, 51+x, color);
uLCD.line(21, 52+x, 28, 52+x, color);
uLCD.line(30, 52+x, 36, 52+x, color);
uLCD.line(37, 52+x, 40, 52+x, color);
uLCD.line(22, 53+x, 36, 53+x, color);
uLCD.line(22, 54+x, 37, 54+x, color);
uLCD.line(23, 55+x, 38, 55+x, color);
uLCD.line(24, 56+x, 37, 56+x, color);
uLCD.line(24, 57+x, 35, 57+x, color);
uLCD.line(25, 58+x, 29, 58+x, color);
uLCD.line(27, 59+x, 28, 59+x, color);
}
void drawPaper(int color, int x) {
    uLCD.line(67, 35+x, 68, 35+x, color);
uLCD.line(66, 36+x, 69, 36+x, color);
uLCD.line(65, 37+x, 68, 37+x, color);
uLCD.line(71, 37+x, 73, 37+x, color);
uLCD.line(64, 38+x, 67, 38+x, color);
uLCD.line(70, 38+x, 73, 38+x, color);
uLCD.line(57, 39+x, 58, 39+x, color);
uLCD.line(64, 39+x, 67, 39+x, color);
uLCD.line(69, 39+x, 72, 39+x, color);
uLCD.line(56, 40+x, 58, 40+x, color);
uLCD.line(63, 40+x, 66, 40+x, color);
uLCD.line(68, 40+x, 71, 40+x, color);
uLCD.line(74, 40+x, 75, 40+x, color);
uLCD.line(55, 41+x, 59, 41+x, color);
uLCD.line(62, 41+x, 65, 41+x, color);
uLCD.line(67, 41+x, 70, 41+x, color);
uLCD.line(73, 41+x, 75, 41+x, color);
uLCD.line(55, 42+x, 58, 42+x, color);
uLCD.line(61, 42+x, 64, 42+x, color);
uLCD.line(66, 42+x, 69, 42+x, color);
uLCD.line(72, 42+x, 75, 42+x, color);
uLCD.line(54, 43+x, 58, 43+x, color);
uLCD.line(60, 43+x, 63, 43+x, color);
uLCD.line(65, 43+x, 68, 43+x, color);
uLCD.line(71, 43+x, 74, 43+x, color);
uLCD.line(54, 44+x, 57, 44+x, color);
uLCD.line(59, 44+x, 63, 44+x, color);
uLCD.line(64, 44+x, 68, 44+x, color);
uLCD.line(70, 44+x, 73, 44+x, color);
uLCD.line(53, 45+x, 57, 45+x, color);
uLCD.line(58, 45+x, 67, 45+x, color);
uLCD.line(69, 45+x, 72, 45+x, color);
uLCD.line(75, 45+x, 76, 45+x, color);
uLCD.line(53, 46+x, 57, 46+x, color);
uLCD.line(59, 46+x, 62, 46+x, color);
uLCD.line(63, 46+x, 66, 46+x, color);
uLCD.line(68, 46+x, 71, 46+x, color);
uLCD.line(73, 46+x, 76, 46+x, color);
uLCD.line(53, 47+x, 58, 47+x, color);
uLCD.line(59, 47+x, 62, 47+x, color);
uLCD.line(63, 47+x, 70, 47+x, color);
uLCD.line(72, 47+x, 75, 47+x, color);
uLCD.line(53, 48+x, 58, 48+x, color);
uLCD.line(59, 48+x, 62, 48+x, color);
uLCD.line(64, 48+x, 69, 48+x, color);
uLCD.line(71, 48+x, 74, 48+x, color);
uLCD.line(53, 49+x, 58, 49+x, color);
uLCD.line(59, 49+x, 63, 49+x, color);
uLCD.line(64, 49+x, 68, 49+x, color);
uLCD.line(70, 49+x, 73, 49+x, color);
uLCD.line(53, 50+x, 58, 50+x, color);
uLCD.line(59, 50+x, 63, 50+x, color);
uLCD.line(65, 50+x, 68, 50+x, color);
uLCD.line(69, 50+x, 72, 50+x, color);
uLCD.line(53, 51+x, 64, 51+x, color);
uLCD.line(66, 51+x, 71, 51+x, color);
uLCD.line(53, 52+x, 70, 52+x, color);
uLCD.line(53, 53+x, 69, 53+x, color);
uLCD.line(53, 54+x, 68, 54+x, color);
uLCD.line(52, 55+x, 67, 55+x, color);
uLCD.line(52, 56+x, 66, 56+x, color);
uLCD.line(53, 57+x, 64, 57+x, color);
uLCD.line(54, 58+x, 63, 58+x, color);
uLCD.line(55, 59+x, 59, 59+x, color);
uLCD.line(57, 60+x, 58, 60+x, color);
}

void drawScissors(int color, int x) {
uLCD.line(100, 34+x, 101, 34+x, color);
uLCD.line(99, 35+x, 102, 35+x, color);
uLCD.line(99, 36+x, 101, 36+x, color);
uLCD.line(98, 37+x, 101, 37+x, color);
uLCD.line(97, 38+x, 100, 38+x, color);
uLCD.line(97, 39+x, 100, 39+x, color);
uLCD.line(96, 40+x, 99, 40+x, color);
uLCD.line(105, 40+x, 109, 40+x, color);
uLCD.line(95, 41+x, 99, 41+x, color);
uLCD.line(104, 41+x, 108, 41+x, color);
uLCD.line(95, 42+x, 98, 42+x, color);
uLCD.line(102, 42+x, 107, 42+x, color);
uLCD.line(101, 43+x, 105, 43+x, color);
uLCD.line(99, 44+x, 103, 44+x, color);
uLCD.line(92, 45+x, 98, 45+x, color);
uLCD.line(100, 45+x, 102, 45+x, color);
uLCD.line(90, 46+x, 99, 46+x, color);
uLCD.line(89, 47+x, 94, 47+x, color);
uLCD.line(97, 47+x, 99, 47+x, color);
uLCD.line(88, 48+x, 93, 48+x, color);
uLCD.line(95, 48+x, 96, 48+x, color);
uLCD.line(88, 49+x, 91, 49+x, color);
uLCD.line(93, 49+x, 96, 49+x, color);
uLCD.line(99, 49+x, 102, 49+x, color);
uLCD.line(87, 50+x, 91, 50+x, color);
uLCD.line(93, 50+x, 94, 50+x, color);
uLCD.line(97, 50+x, 102, 50+x, color);
uLCD.line(87, 51+x, 91, 51+x, color);
uLCD.line(92, 51+x, 93, 51+x, color);
uLCD.line(95, 51+x, 101, 51+x, color);
uLCD.line(87, 52+x, 91, 52+x, color);
uLCD.line(92, 52+x, 93, 52+x, color);
uLCD.line(95, 52+x, 98, 52+x, color);
uLCD.line(86, 53+x, 91, 53+x, color);
uLCD.line(92, 53+x, 93, 53+x, color);
uLCD.line(99, 53+x, 101, 53+x, color);
uLCD.line(86, 54+x, 90, 54+x, color);
uLCD.line(92, 54+x, 95, 54+x, color);
uLCD.line(97, 54+x, 102, 54+x, color);
uLCD.line(85, 55+x, 94, 55+x, color);
uLCD.line(96, 55+x, 100, 55+x, color);
uLCD.line(85, 56+x, 95, 56+x, color);
uLCD.line(96, 56+x, 97, 56+x, color);
uLCD.line(86, 57+x, 95, 57+x, color);
uLCD.line(86, 58+x, 96, 58+x, color);
uLCD.line(88, 59+x, 94, 59+x, color);
uLCD.line(89, 60+x, 91, 60+x, color);
}

void drawEneRockFrame() {
    uLCD.rectangle(17, 28+2, 45, 65-2, BLACK);
}

void drawEnePaperFrame() {
    uLCD.rectangle(17+32, 28+2, 45+32, 65-2, BLACK);
}

void drawEneSciFrame() {
    uLCD.rectangle(17+32*2+1, 28+2, 45+32*2+1, 65-2, BLACK);
}

void drawMyRockFrame() {
    uLCD.rectangle(17, 28+32+4, 45, 65+32-2, BLACK);
}

void drawMyPaperFrame() {
    uLCD.rectangle(17+32, 28+32+4, 45+32, 65+32-2, BLACK);
}

void drawMySciFrame() {
    uLCD.rectangle(17+32*2+1, 28+32+4, 45+32*2+1, 65+32-2, BLACK);
}

void displayOption3() {
    clearMiddle();
    drawRock(BLACK, 0);
    drawPaper(BLACK, 0);
    drawScissors(BLACK, 0);
    drawRock(BLACK, 32);
    drawPaper(BLACK, 32);
    drawScissors(BLACK, 32);
}


// draw end

class Pet {
public:
    Pet() {
        setAge(0);
        setWeight(5);
        setDiscipline(0);
        setHungry(0);
        setHappy(0);
    }
    
    void increaseAge() {
        age = age + 1;
    }
    
    void setAge(int _age) {
        age = _age;
    }
    int getAge() {
        return age;
    }
    
    void setWeight(int _weight) {
        weight = _weight;
    }
    int getWeight() {
        return weight;
    }
    
    void increaseDiscipline() {
        if (discipline < 4) {
            discipline = discipline + 1;
        }
    }
    void decreaseDiscipline() {
        if (discipline > 0) {
            discipline = discipline - 1;
        }
    }
    void setDiscipline(int _discipline) {
        discipline = _discipline;
    }
    int getDiscipline() {
        return discipline;
    }
    
    void increaseHungry() {
        if (hungry < 4) {
            hungry = hungry + 1;
        }
    }
    void decreaseHungry() {
        if (hungry > 0) {
            hungry = hungry - 1;
        }
    }
    void setHungry(int _hungry) {
        hungry = _hungry;
    }
    int getHungry() {
        return hungry;
    }
    
    
    void increaseHappy() {
        if (happy < 4) {
            happy = happy + 1;
        }
    }
    void decreaseHappy() {
        if (happy > 0) {
            happy = happy - 1;
        }
    }
    void setHappy(int _happy) {
        happy = _happy;
    }
    int getHappy() {
        return happy;
    }
    
private:
    int age;
    int weight;
    int discipline;
    int hungry;
    int happy;
};


void thread1(void const *args)
{
    wave_file=fopen("/sd/song.wav","r");
    if(wave_file == NULL) {
        error("Could not open file for write\n");
    }
    waver.play(wave_file);
    Thread::wait(500); // wait 0.5s
    fclose(wave_file);
}



Pet pet;


void displayOption6() {
    clearMiddle();
    
    printf("%d\n\r", info_state);
    
    if (info_state%4 == 0) {
        uLCD.text_width(3); // 4 times
        uLCD.text_height(3);
        uLCD.locate(0, 1);
        uLCD.printf("AGE: %d\n", pet.getAge());
        uLCD.locate(0, 2);
        uLCD.printf("W:   %d\n", pet.getWeight());
    } else if (info_state%4 == 1) { //discipline
        uLCD.text_width(3); // 4 times
        uLCD.text_height(3);
        uLCD.locate(0, 1);
        uLCD.printf("Discip");
        if (pet.getDiscipline() == 0) {
            uLCD.circle(16, 72, 10, BLACK);
            uLCD.circle(16+32, 72, 10, BLACK);
            uLCD.circle(16+32*2, 72, 10, BLACK);
            uLCD.circle(16+32*3, 72, 10, BLACK);
        } else if (pet.getDiscipline() == 1) {
            uLCD.filled_circle(16, 72, 10, RED);
            uLCD.circle(16+32, 72, 10, BLACK);
            uLCD.circle(16+32*2, 72, 10, BLACK);
            uLCD.circle(16+32*3, 72, 10, BLACK);
        } else if (pet.getDiscipline() == 2) {
            uLCD.filled_circle(16, 72, 10, RED);
            uLCD.filled_circle(16+32, 72, 10, RED);
            uLCD.circle(16+32*2, 72, 10, BLACK);
            uLCD.circle(16+32*3, 72, 10, BLACK);
        } else if (pet.getDiscipline() == 3) {
            uLCD.filled_circle(16, 72, 10, RED);
            uLCD.filled_circle(16+32, 72, 10, RED);
            uLCD.filled_circle(16+32*2, 72, 10, RED);
            uLCD.circle(16+32*3, 72, 10, BLACK);
        } else if (pet.getDiscipline() == 4) {
            uLCD.filled_circle(16, 72, 10, RED);
            uLCD.filled_circle(16+32, 72, 10, RED);
            uLCD.filled_circle(16+32*2, 72, 10, RED);
            uLCD.filled_circle(16+32*3, 72, 10, RED);
        }
    } else if (info_state%4 == 2) { //hungry
        uLCD.text_width(3); // 4 times
        uLCD.text_height(3);
        uLCD.locate(0, 1);
        uLCD.printf("Hungry");
        if (pet.getHungry() == 0) {
            uLCD.circle(16, 72, 10, BLACK);
            uLCD.circle(16+32, 72, 10, BLACK);
            uLCD.circle(16+32*2, 72, 10, BLACK);
            uLCD.circle(16+32*3, 72, 10, BLACK);
        } else if (pet.getHungry() == 1) {
            uLCD.filled_circle(16, 72, 10, RED);
            uLCD.circle(16+32, 72, 10, BLACK);
            uLCD.circle(16+32*2, 72, 10, BLACK);
            uLCD.circle(16+32*3, 72, 10, BLACK);
        } else if (pet.getHungry() == 2) {
            uLCD.filled_circle(16, 72, 10, RED);
            uLCD.filled_circle(16+32, 72, 10, RED);
            uLCD.circle(16+32*2, 72, 10, BLACK);
            uLCD.circle(16+32*3, 72, 10, BLACK);
        } else if (pet.getHungry() == 3) {
            uLCD.filled_circle(16, 72, 10, RED);
            uLCD.filled_circle(16+32, 72, 10, RED);
            uLCD.filled_circle(16+32*2, 72, 10, RED);
            uLCD.circle(16+32*3, 72, 10, BLACK);
        } else if (pet.getHungry() == 4) {
            uLCD.filled_circle(16, 72, 10, RED);
            uLCD.filled_circle(16+32, 72, 10, RED);
            uLCD.filled_circle(16+32*2, 72, 10, RED);
            uLCD.filled_circle(16+32*3, 72, 10, RED);
        }
    } else if (info_state%4 == 3) { //happy
        uLCD.text_width(3); // 4 times
        uLCD.text_height(3);
        uLCD.locate(0, 1);
        uLCD.printf("Happy");
        if (pet.getHappy() == 0) {
            uLCD.circle(16, 72, 10, BLACK);
            uLCD.circle(16+32, 72, 10, BLACK);
            uLCD.circle(16+32*2, 72, 10, BLACK);
            uLCD.circle(16+32*3, 72, 10, BLACK);
        } else if (pet.getHappy() == 1) {
            uLCD.filled_circle(16, 72, 10, RED);
            uLCD.circle(16+32, 72, 10, BLACK);
            uLCD.circle(16+32*2, 72, 10, BLACK);
            uLCD.circle(16+32*3, 72, 10, BLACK);
        } else if (pet.getHappy() == 2) {
            uLCD.filled_circle(16, 72, 10, RED);
            uLCD.filled_circle(16+32, 72, 10, RED);
            uLCD.circle(16+32*2, 72, 10, BLACK);
            uLCD.circle(16+32*3, 72, 10, BLACK);
        } else if (pet.getHappy() == 3) {
            uLCD.filled_circle(16, 72, 10, RED);
            uLCD.filled_circle(16+32, 72, 10, RED);
            uLCD.filled_circle(16+32*2, 72, 10, RED);
            uLCD.circle(16+32*3, 72, 10, BLACK);
        } else if (pet.getHappy() == 4) {
            uLCD.filled_circle(16, 72, 10, RED);
            uLCD.filled_circle(16+32, 72, 10, RED);
            uLCD.filled_circle(16+32*2, 72, 10, RED);
            uLCD.filled_circle(16+32*3, 72, 10, RED);
        }
    }
}




int main() {
    
    Thread t1(thread1);
    
    bool fired = 0;
    
    uLCD.baudrate(1500000);
    uLCD.textbackground_color(WHITE);
    uLCD.color(BLACK);
    
    
    int getpositionx = 48;
    int getpositiony = 70;
    

    

    
    Thread::wait(100);
    
    drawBackground();
    
    menu_state = 0;
    arrow_state = 0;
    light_state = 0;
    info_state = 0;
    bool sick_state = 0;
    bool poop_state = 0;
    bool sleep_state = 0;
    
    int rand_sick;
    int rand_sleep;
    
    int token = 0;

    
    //monster1.draw();
    
    int poop_count = 0;
    
    while(1) {
        
        if (light_state == 1) { // light off
                    
        } else {
            if (sleep_state == 1) {
                uLCD.BLIT(getpositionx, getpositiony, MONSTER_WIDTH, MONSTER_HEIGHT, MONSTER1_SLEEP1);
                if (poop_state == 1) {
                    uLCD.BLIT(100, 85, 11, 8, POOP);
                }
            } else { 
                if (sick_state == 1) {                   
                    
                    uLCD.BLIT(getpositionx, getpositiony, MONSTER_WIDTH, MONSTER_HEIGHT, MONSTER1_SICK1);      
                    if (poop_state == 1) {
                        uLCD.BLIT(100, 85, 11, 8, POOP);
                    }
                } else {
                    if (token == 1) {
                        uLCD.BLIT(getpositionx, getpositiony, MONSTER_WIDTH, MONSTER_HEIGHT, MONSTER1_1);
                        if (poop_state == 1) {
                            uLCD.BLIT(100, 85, 11, 8, POOP);
                        }
                    } else if (token == 100000) {
                        uLCD.BLIT(getpositionx, getpositiony, MONSTER_WIDTH, MONSTER_HEIGHT, MONSTER1_2);
                        if (poop_state == 1) {
                            uLCD.BLIT(100, 85, 11, 8, POOP);
                        }
                    } else if (token == 200000) {
                        token = 0;   
                        // sleep
                        rand_sleep = rand()%10000 + 1;
                        if (rand_sleep <= 10) {
                            sleep_state = 1;
                        }
            
                        // sick
                        rand_sick = rand()%10000 + 1;
                        if (poop_state == 1) {
                            if (rand_sick <= 50) {
                                sick_state = 1;    
                            }
                        } else {
                            if (rand_sick <= 10) {
                                sick_state = 1;    
                            }
                        }
                    }
                    token++;
                }
            }
            
        }
        
        // poop
        poop_count++;
        if (poop_count == 10000000) {
            if (poop_state == 0) {
                //uLCD.BLIT(90, 80, 11, 8, ERASE_POOP);
                uLCD.BLIT(100, 85, 11, 8, POOP);
                //poop_draw(90,80);
                poop_state = 1;    
            } 
            poop_count = 0;
        }
        
        
        
        
        
        
        
        
  
          if (myNav.right()) { // left
            if (menu_state > 1) {
                menu_state--;   
            }
            
             switch (menu_state) {
                case 1: drawMenu2(0xA0A0A0);
                    drawMenu1(BLACK);
                    break;
                case 2: drawMenu3(0xA0A0A0);
                    drawMenu2(BLACK);
                    break;
                case 3: drawMenu4(0xA0A0A0);
                    drawMenu3(BLACK);
                    break;
                case 4: drawMenu5(0xA0A0A0);
                    drawMenu4(BLACK);
                    break;
                case 5: drawMenu6(0xA0A0A0);
                    drawMenu5(BLACK);
                    break;
                case 6: drawMenu7(0xA0A0A0);
                    drawMenu6(BLACK);
                    break;
                case 7: drawMenu8(0xA0A0A0);
                    drawMenu7(BLACK);
                    break;
            }
            Thread::wait(500);
            
        } else if (myNav.left()) { // right
            if (menu_state < 8) {
                menu_state++;    
            }
             switch (menu_state) {
                case 1: drawMenu1(BLACK);
                    break;
                case 2: drawMenu1(0xA0A0A0);
                    drawMenu2(BLACK);
                    break;
                case 3: drawMenu2(0xA0A0A0);
                    drawMenu3(BLACK);
                    break;
                case 4: drawMenu3(0xA0A0A0);
                    drawMenu4(BLACK);
                    break;
                case 5: drawMenu4(0xA0A0A0);
                    drawMenu5(BLACK);
                    break;
                case 6: drawMenu5(0xA0A0A0);
                    drawMenu6(BLACK);
                    break;
                case 7: drawMenu6(0xA0A0A0);
                    drawMenu7(BLACK);
                    break;
                case 8: drawMenu7(0xA0A0A0);
                    drawMenu8(BLACK);
                    break;
            }
            Thread::wait(500);
            
            
        } else if (myNav.down()) { // up
            if (menu_state == 5) {
                menu_state = 1;   
            } else if (menu_state == 6) {
                menu_state = 2;   
            } else if (menu_state == 7) {
                menu_state = 3;   
            } else if (menu_state == 8) {
                menu_state = 4;   
            }
            
            switch (menu_state) {
                case 1: drawMenu5(0xA0A0A0);
                    drawMenu1(BLACK);
                    break;
                case 2: drawMenu6(0xA0A0A0);
                    drawMenu2(BLACK);
                    break;
                case 3: drawMenu7(0xA0A0A0);
                    drawMenu3(BLACK);
                    break;
                case 4: drawMenu8(0xA0A0A0);
                    drawMenu4(BLACK);
                    break;
            }
            
            Thread::wait(500);
        } else if (myNav.up()) { // down
            if (menu_state == 1) {
                menu_state = 5;   
            } else if (menu_state == 2) {
                menu_state = 6;   
            } else if (menu_state == 3) {
                menu_state = 7;   
            } else if (menu_state == 4) {
                menu_state = 8;   
            }
            
            switch (menu_state) {
                case 5: drawMenu1(0xA0A0A0);
                    drawMenu5(BLACK);
                    break;
                case 6: drawMenu2(0xA0A0A0);
                    drawMenu6(BLACK);
                    break;
                case 7: drawMenu3(0xA0A0A0);
                    drawMenu7(BLACK);
                    break;
                case 8: drawMenu4(0xA0A0A0);
                    drawMenu8(BLACK);
                    break;
            } 
            Thread::wait(500);
        } else if (myNav.fire()) {
            fired = 1;
            Thread::wait(500);
        }
           
    
        if (fired == 1) {
            fired = 0;
            if (menu_state == 1) {
                if (light_state == 1) { // light off
                    
                } else {
                    clearMiddle();
                    for (int i = 0; i < 10000000; i++) {
                        if (i == 0) {
                            uLCD.BLIT(55, 60, 22, 17, FOOD);
                        }
                        if (i== 5000000) {
                            clearMiddle();
                            uLCD.BLIT(55, 70, 22, 6, FOOD2);
                        }
                    }
                    
                    clearMiddle();
    
                    //monster1.draw();
                    pet.increaseHungry();
                }
                drawMenu1(0xA0A0A0);
                menu_state = 0;
                sleep_state = 0;
            } else if (menu_state == 2) {                     
                displayOption2();
                while (1) {

                    if (myNav.up() || myNav.down()) {
                        
                        if (arrow_state == 0) {
                            arrow_state = 1;
                        } else {
                            arrow_state = 0;
                        }
                        displayOption2();
                        Thread::wait(500);
                        
                    } else if (myNav.fire()) {
                        if (arrow_state == 0) {
                            clearMiddle();
                            //monster1.draw();
                            light_state = 0;
                        } else {
                            turnOffLight();
                            light_state = 1;
                        }
                        Thread::wait(500);
                        break;
                    } 
                }
                arrow_state = 0;
                drawMenu2(0xA0A0A0);
                menu_state = 0;
            } else if (menu_state == 3) {
                if (light_state == 1) { // light off
                    
                } else {

                    
                    displayOption3();
                    
                    int ene = rand()%3+1;
                    int result = 0; // 1: win 2: lose 3: tie
                    
                    while (1) {

                        if (myNav.right()) {
                            drawMyRockFrame();
                            if (ene == 1) {
                                drawEneRockFrame();
                                result = 3;
                            } else if (ene == 2) {
                                drawEnePaperFrame();
                                result = 2;
                            } else if (ene == 3) {
                                drawEneSciFrame();
                                result = 1;
                            }
                            Thread::wait(2000);
                        } else if (myNav.fire()) {
                            drawMyPaperFrame();
                            if (ene == 1) {
                                drawEneRockFrame();
                                result = 1;
                            } else if (ene == 2) {
                                drawEnePaperFrame();
                                result = 3;
                            } else if (ene == 3) {
                                drawEneSciFrame();
                                result = 2;
                            }
                            Thread::wait(2000);
                        } else if (myNav.left()) {
                            drawMySciFrame();
                            if (ene == 1) {
                                drawEneRockFrame();
                                result = 2;
                            } else if (ene == 2) {
                                drawEnePaperFrame();
                                result = 1;
                            } else if (ene == 3) {
                                drawEneSciFrame();
                                result = 3;
                            }
                            Thread::wait(2000);
                        }
                        
                        if (result == 3) {
                            clearMiddle();
                            uLCD.text_width(4); // 4 times
                            uLCD.text_height(4);
                            uLCD.locate(0, 1);
                            uLCD.printf("TIE");
                            Thread::wait(2000);
                            ene = rand()%3+1;
                            displayOption3();
                            result = 0;
                        } else if (result == 1) {
                            clearMiddle();
                            uLCD.text_width(4); // 4 times
                            uLCD.text_height(4);
                            uLCD.locate(0, 1);
                            uLCD.printf("WIN");
                            pet.increaseHappy();
                            Thread::wait(2000);
                            break;
                        } else if (result == 2) {
                            clearMiddle();
                            uLCD.text_width(4); // 4 times
                            uLCD.text_height(4);
                            uLCD.locate(0, 1);
                            uLCD.printf("LOSE");
                            pet.decreaseHappy();
                            Thread::wait(2000);
                            break;
                        }
                    }
                    clearMiddle();
                    //monster1.draw();
                }
                drawMenu3(0xA0A0A0);
                menu_state = 0;
                sleep_state = 0;
            } else if (menu_state == 4) { // medicine
                if (light_state == 1) { // light off
                    
                } else {
                    clearMiddle();
                    for (int i = 0; i < 10000000; i++) {
                        if (i == 0) {
                            uLCD.BLIT(60, 58, 16, 16, MED);
                        }
                        if (i== 5000000) {
                            clearMiddle();
                            uLCD.BLIT(60, 66, 16, 8, MED2);
                        }
                    }
                    
                    clearMiddle();
                    
                }
                drawMenu4(0xA0A0A0);
                menu_state = 0;
                sick_state = 0;
                sleep_state = 0;
            } else if (menu_state == 5) { // poop
                if (light_state == 1) { // light off
                    
                } else {
                    for (int i = 0; i < 128; i = i + 5) {
                        if (i == 0) {
                            uLCD.filled_rectangle(0+i, 26, 5+i,127-25+1, BLACK);
                        } else {
                            uLCD.filled_rectangle(0+i-5, 26, 5+i-5,127-25+1, WHITE);
                            uLCD.filled_rectangle(0+i, 26, 5+i,127-25+1, BLACK);
                        }
                        Thread::wait(100);
                    }
                    poop_state = 0;
                    poop_count = 0;
                    clearMiddle();
                    //monster1.draw();
                }
                drawMenu5(0xA0A0A0);
                menu_state = 0;
            } else if (menu_state == 6) { // info // working
                displayOption6();
                while (1) {

                    
                    if (myNav.left()) {
                        info_state = info_state + 1;
                        displayOption6();
                        Thread::wait(500);
                    } else if (myNav.right()) {
                        info_state = info_state - 1;
                        if (info_state < 0) {
                            info_state = info_state + 4; 
                        }
                        displayOption6();
                        Thread::wait(500);
                    } else if (myNav.fire()) {
                        Thread::wait(500);
                        break;
                    }                   
                }
                info_state = 0;
                
                if (light_state == 1) { // light off
                    drawUpperFrame();
                    drawUpperMenu();
                    turnOffLight();
                } else {
                    clearMiddle();
                    drawUpperFrame();
                    drawUpperMenu();
                    
                    //monster1.draw();
                }
                drawMenu6(0xA0A0A0);
                menu_state = 0;
            } else if (menu_state == 7) { // yell
                if (light_state == 1) { // light off
                    
                } else {
                    for (int i = 0; i < 10000000; i++) {
                        if (i % 1000000 == 0) {
                            uLCD.BLIT(getpositionx, getpositiony, MONSTER_WIDTH, MONSTER_HEIGHT, MONSTER1_MAD1);
                        }
                    }
                    
                    clearMiddle();
                    //monster1.draw();
                    pet.increaseDiscipline();
                    pet.decreaseHappy();
                }
                
                drawMenu7(0xA0A0A0);
                menu_state = 0;
                sleep_state = 0;
            } else if (menu_state == 8) {
                pet.increaseAge();
                drawMenu8(0xA0A0A0);
                menu_state = 0;
                sleep_state = 0;
            }             
        } 
        
        
    }
    
    
}

