/*********************************************************************** 
**  ██████╗ ███████╗██╗███████╗██╗    ██╗ █████╗ ██████╗ ███╗   ███╗  **
**  ██╔══██╗██╔════╝██║██╔════╝██║    ██║██╔══██╗██╔══██╗████╗ ████║  **
**  ██████╔╝███████╗██║███████╗██║ █╗ ██║███████║██████╔╝██╔████╔██║  **
**  ██╔═══╝ ╚════██║██║╚════██║██║███╗██║██╔══██║██╔══██╗██║╚██╔╝██║  **
**  ██║     ███████║██║███████║╚███╔███╔╝██║  ██║██║  ██║██║ ╚═╝ ██║  **
**  ╚═╝     ╚══════╝╚═╝╚══════╝ ╚══╝╚══╝ ╚═╝  ╚═╝╚═╝  ╚═╝╚═╝     ╚═╝  **
************************************************************************
**(C) Dr James Hilder - York Robotics Laboratory - University of York **
***********************************************************************/

/// PsiSwarm Beautiful Meme Project Source Code
/// Version 0.2
/// James Hilder, Alan Millard, Homero Elizondo, Jon Timmis
/// University of York

#ifndef MAIN_H
#define MAIN_H

#include "psiswarm.h"
#include "beacon.h"
#include "programs.h"
#include "vector.h"

// Define the on-period for a IR pulse in microseconds (eg 50000 for 2Hz system, 25000 for a 4Hz system or 20000 for a 5Hz system)
#define BEACON_PERIOD 25000        

extern char beacon_found;                       // This will be a 1 if beacon is detected, 0 if it isn't 
extern int beacon_heading;                      // The heading from the last time the beacon was detected
extern char robots_found[8];                    // These will be a 1 when the respective robot [excluding self] was detected during the previous 500ms window
extern int robots_heading[8];                   // These are the headings from the last time the respective robots were detected
extern unsigned short robots_distance[8];       // This is the maximum sensor value from the last time the respective robot was detected
extern unsigned short reflected_sensor_data[8]; // The reflected IR values when this robots emitters are on
extern unsigned short background_sensor_data[8];// The raw IR values when no robot (or beacon) should have its IR on
extern char disable_ir_emitters; 
extern char step_cycle;
extern char target_reached;
extern char recharging_state;
extern char prog_name [17];
extern char prog_info [17];
extern char main_program_state;
extern char program_changed;   
extern char program_run_init;
extern float battery_low_threshold;      
extern float battery_high_threshold; 
extern int flocking_headings[8];

char * get_program_name(int index);
void set_program(int index);
void set_program_info(char * info);

void update_display(void);
void display_debug_info(void);

void user_code_setup(void);
void user_code_loop(void);
void handle_switch_event(char switch_state);

int main(void);



void display_ir_readings(void);
void out(const char* format, ...) ;

#endif