#include "mbed.h"
#include "C12832_lcd.h"

const float WaterSetPoint = 0.5f;


C12832_LCD lcd;                                 //define object lcd

AnalogIn WaterLevelSensor(p19);                       //Left pot simulates level of water
AnalogIn ChlorineLevelSensor(p20);                    //right pot simulater level of chlorine



int main()
{

    lcd.cls();                                  //clear lcd
    lcd.set_contrast(15);                       //lcd contrast set value 15 (0-63)


    while(1) {
        lcd.cls();
        float WaterLevel = WaterLevelSensor;
        float ChlorineLevel = ChlorineLevelSensor;

        lcd.locate(0,0);
        lcd.printf("Chlorine : %.2f",ChlorineLevel);

        lcd.locate(0,9);
        lcd.printf("Water    : %.2f",WaterLevel);

        float WaterError = WaterSetPoint - WaterLevel;

        if(WaterError > 0) {
            lcd.locate(0,18);
            lcd.printf("Pump ON ");
        } else {
            lcd.locate(0,18);
            lcd.printf("Pump OFF");
        }

        if(WaterError > 0) {
            lcd.locate(0,18);
            lcd.printf("Pump ON ");
        } else {
            lcd.locate(0,18);
            lcd.printf("Pump OFF");
        }

        if(ChlorineLevel > 0.2f) {
            lcd.locate(50,18);
            lcd.printf("Cl:OFF");
        }
        if((ChlorineLevel <=0.2)&&(ChlorineLevel> 0.1f)) {
            lcd.locate(50,18);
            lcd.printf("Cl: 1 shot");
        }
        if(ChlorineLevel <=0.1) {
            lcd.locate(50,18);
            lcd.printf("Cl: 2 shots");
        }





        wait(1);
    }
}
