/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "C12832.h"
#include "thread.h"

// Using Arduino pin notation


// Blinking rate in milliseconds
#define BLINKING_RATE_MS                     500

DigitalOut red_led(D5);
DigitalOut blue_led(D8);
DigitalOut green_led(D9);

/*joystick*/
DigitalIn up(A2);
DigitalIn down(A3);
DigitalIn left(A4);
AnalogIn right(A5);
DigitalIn fire(D4);



int main()
{
    // Initialise the digital pin LED1 as an output
    //DigitalOut led(LED1);
  
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("mbed application shield!");
    
    lcd_thread.start(LCD_refresh_thread);
    while (true) {

        
        red_led =  !up && ! fire;
        blue_led = !down;
        green_led= !left && !right;
        thread_sleep_for(BLINKING_RATE_MS);
    }
}
