#ifndef HCSR04_H
#define HCSR04_H
#include "rtc.h"
#include "mbed.h"
 
class HCSR04{
    public:
        HCSR04(DigitalOut *trig, DigitalIn *echo, Timer *timer);
        float getDist()const ;
        int measDist();
        void setRange(float range);
        bool inRange();
    private:
        DigitalOut *_trig ;
        DigitalIn *_echo ;

        Timer *_timer ;
        int _dist ;
        float _range ;
};

//Usensor time params
struct Usensor
{
  int dist;
  int time_in_min;
  int time_in_sec;
  int time_out_min;
  int time_out_sec;
};
 
extern Timer sensorTimer ;
extern Timer sensorTimer2 ;
extern DigitalOut trig0 ;//(D4) ;
extern DigitalOut trig1 ;//(D5) ;
//extern DigitalOut trig2 ;//(D6) ;
//extern DigitalOut trig3 ;//(D7) ;

extern DigitalIn  echo0 ;//(A5) ;
extern DigitalIn  echo1 ;//(A4) ;
//extern DigitalIn  echo2 ;//(A3) ;
//extern DigitalIn  echo3 ;//(A2) ;

extern HCSR04 sensor0 ;//(&trig0, &echo0, &sensorTimer);//avant
extern HCSR04 sensor1 ;//(&trig1, &echo1, &sensorTimer);//arriere
//extern HCSR04 sensor2 ;//(&trig2, &echo2, &sensorTimer);//gauche
//extern HCSR04 sensor3 ;//(&trig3, &echo3, &sensorTimer);//droite


extern Timer t ;
extern HCSR04 capteur0;
extern Timer t1 ;
extern HCSR04 capteur1;

extern Usensor Usensor0;
extern Usensor Usensor1;
void usensor_paraInit();
void usensor_paraClear();
#endif