#include "mbed.h"
#include "HCSR04.h"
#include "rtc.h"
HCSR04::HCSR04(DigitalOut *trig, DigitalIn *echo, Timer *timer): _trig(trig), _echo(echo), _timer(timer),_dist(0)
{
    _range = 10.0 ;
}

float HCSR04::getDist()const
{
    return _dist ;
}

int HCSR04::measDist()
{
    _timer->reset();
    _timer->start();
    *_trig = 1 ;
    wait_us(10);
    *_trig = 0 ;
    while(*_echo == 0);
    _timer->reset();
    while(*_echo == 1 && _timer->read_ms()<25.0);
    _timer->stop();
    _dist = _timer->read_us()/58.0;
    return _dist;
}

void HCSR04::setRange(float range)
{
    _range = range;
}

bool HCSR04::inRange()
{
    return measDist()<_range ;
}

void usensor_paraInit()
{
    Usensor0.dist = 300;
    Usensor1.dist = 300;
    //carState = nothing;
}

void usensor_paraClear()
{
    Usensor0.dist = 300;
    Usensor1.dist = 300;

    Usensor0.time_in_min = 0;
    Usensor0.time_in_sec = 0;
    Usensor0.time_out_min = 0;
    Usensor0.time_out_sec = 0;
    Usensor1.time_in_min = 0;
    Usensor1.time_in_sec = 0;
    Usensor1.time_out_min = 0;
    Usensor1.time_out_sec = 0;
}
/*
HCSR04_0
    PING:
        Trig :D5
        Echo :D9
*/
DigitalOut trig0(D5);
DigitalIn  echo0(D9);
Timer t ;
HCSR04 capteur0(&trig0, &echo0, &t);
/*
HCSR04_1
    PING:
        Trig :D2
        Echo :D7
*/
DigitalOut trig1(D2);
DigitalIn  echo1(D7);
Timer t1 ;
HCSR04 capteur1(&trig1, &echo1, &t1);

Usensor Usensor0;
Usensor Usensor1;

