#include "mbed.h"

/* 
 * This program is a port of an AD9851 DDS Arduino sketch by Andrew Smallbone at www.rocketnumbernine.com
 * It was later modified for testing the inexpensive AD9850 ebay DDS modules
 * Pictures and pinouts at nr8o.dhlpilotcentral.com
 * AD9850 datasheet at http://www.analog.com/static/imported-files/data_sheets/AD9850.pdf
 * Use freely
 * Ported by Alan Matheson on 20 February 2014
 */
 
 
 //efine W2_CLK      // connect to AD9850 module2 word load clock pin (CLK) 
 //efine W1_CLK 12   // connect to AD9850 module1 word load clock pin (CLK)
 //efine FQ_UD p5    // connect to freq update pin (FQ)
 //efine DATA 10     // connect to serial data load pin (DATA)
 //efine RESET 9     // connect to reset pin (RST).
 
 #define pulseHigh(pin) {pin = 1; pin = 0; }

 // Pins used are the same as those used in the MBED driver for AD9850 digital synthesizer using hacked SPI interface
 // by Liam Goudge Sept 2013
 // This program allows the desired frequency in MegaHertz to be directly entered and uses bitbanging rather than the SPI pins.



 // configure data pins for output
  DigitalOut FQ_UD(p8);
  DigitalOut W_CLK(p7);
  DigitalOut DATA(p5);
  DigitalOut RESET(p15);
  
  

 
 // transfers a byte, a bit at a time, LSB first to the 9850 via serial DATA line
void tfr_byte_module1(char data)
{
  for (int i=0; i<8; i++, data>>=1) {
  DATA = (data & 0x01);
  pulseHigh(W_CLK);   //after each bit sent, CLK is pulsed high
  }
}

void tfr_byte_module2(char data)
{
  for (int i=0; i<8; i++, data>>=1) {
    DATA =  (data & 0x01);
    pulseHigh(W_CLK);   //after each bit sent, CLK is pulsed high
  }
}


// frequency calc from datasheet page 8 = <sys clock> * <frequency tuning word>/2^32
void sendFrequency(double frequency) {
  int32_t freq = frequency *1e6 * 4294967295/125000000;  // note 125 MHz clock on 9850
  for (int b=0; b<4; b++, freq>>=8) {
    tfr_byte_module1(freq & 0xFF);
  }
  tfr_byte_module1(0X38);   // Final control byte, all 0 for 9850 chip
 }


int main()
{
double frequency;

// Initialise the AD9850 module
 pulseHigh(RESET);
 pulseHigh(W_CLK);
 pulseHigh(FQ_UD);  // this pulse enables serial mode - Datasheet page 12 figure 10


while(1)
  {
   frequency = 7.080;
   sendFrequency(frequency);
   pulseHigh(FQ_UD);
   wait(5.0);
   } 
 }

}


