#include "global.h"
#include "wbit_util.h"
#include "dot_util.h"
#include "commI2C.h"
#include "mbed.h"
#include "mDot.h"
extern Serial pc;
extern bool verbose;
uint8_t j_attempts = 0; //return number of attempts it took to join the network


//network keys
//these are used as backup keys in case nvm memory is corrupted and we can't read the keys correctly
uint8_t key_AppEUI[] = { 0x90, 0xF1, 0x47, 0x90, 0x6C, 0x48, 0x1D, 0x29 };   //AppEui                              
uint8_t key_AppKey[] = { 0x0F, 0xF9, 0xA2, 0x90, 0x2E, 0xAA, 0x6B, 0x8C, 0x6A, 0x4E, 0xFD, 0x67, 0xF9, 0xA6, 0xF3, 0xD3 };   ////OTAA appkey    => loriot "Appkey" -> common to all nodes    

//ADP keys: for xdot spoofer eui ---> need to be uploaded from proc, using EUI: #spoofer (EUI 00-80-00-00-04-00-FF-FF) 
//static uint8_t network_address[] =  {0x01,0x59,0xE2,0xC7};
//static uint8_t network_session_key[] = {0xBA, 0xEF, 0x4D, 0xA3, 0x66, 0xD1, 0x85, 0xDE, 0xB1, 0xCD, 0x79, 0x15, 0xC7, 0xEB, 0x72, 0x35};
//static uint8_t data_session_key[] = {0xF9,0x13,0x94,0x0D,0x12,0x95,0x96,0x5A,0xF4,0x34,0xBB,0xA9,0x8E,0x2A,0x83,0x10};


//============================================================================
// printRadioCfg

//============================================================================
void printRadioCfg(){
      if(verbose){       
        pc.printf("\r\n************************************************************"); 
        pc.printf("\r\n saved radio configuration: ");                
        pc.printf("\r\n public network: %d ",dot->getPublicNetwork()); 
        pc.printf("\r\n subband: %d ",dot->getFrequencySubBand()); 
        pc.printf("\n\r join delay %d ",dot->getJoinDelay());                                   
        pc.printf("\r\n ADR: %d ",dot->getAdr());                 
        pc.printf("\r\n antenna gain: %d ",dot->getAntennaGain());                 
        pc.printf("\r\n transmit max pwr: %d ",dot->getMaxTxPower()); //not saved in cfg                                                        
        pc.printf("\r\n transmit min pwr: %d ",dot->getMinTxPower()); //not saved in cfg                                                        
        pc.printf("\r\n transmit pwr: %d ",dot->getTxPower());                                 
//deprecated API:        pc.printf("\n\r tx inverted %d ",dot->getTxInverted());                                   
//deprecated API:        pc.printf("\n\r rx inverted %d ",dot->getRxInverted());                                   
        pc.printf("\n\r rx delay  %d ",dot->getRxDelay());          
        pc.printf("\r\n TxDataRate: %d ",dot->getTxDataRate());                        
        pc.printf("\r\n maxPktLen: %d ",dot->getMaxPacketLength());  //not saved in cfg                                
        pc.printf("\r\n************************************************************\r\n");         
    }
}
//==============================================================================
//printNmvData
//==============================================================================
void printNmvData(nvm *pNvm){
     uint8_t i;    
     if(verbose){
        pc.printf("\r\n************************************************************"); 
        pc.printf("\r\nnon-volatile memory (nvm):"); 
        pc.printf("\r\nkey_AppEUI:");      
        for (i = 0; i < sizeof(key_AppEUI);i++) 
            pc.printf(" %x",pNvm->key_AppEUI[i]);
        pc.printf("\r\nkey_AppKey:"); 
        for (i = 0 ; i < sizeof(key_AppKey);i++)
            pc.printf(" %x",pNvm->key_AppKey[i]);        
        pc.printf("\r\nbLogOutputOn: %d ",pNvm->bLogOutputOn); 

        pc.printf("\r\nstatic backup keys:"); 
        pc.printf("\r\nkey_AppEUI:");      
        for (i = 0; i < sizeof(key_AppEUI);i++) 
            pc.printf(" %x",key_AppEUI[i]);
        pc.printf("\r\nkey_AppKey:"); 
        for (i = 0 ; i < sizeof(key_AppKey);i++)
            pc.printf(" %x",key_AppKey[i]);        
     }  
     if(verbose)pc.printf("\r\n************************************************************\r\n"); 
}
//==============================================================================
//printNvmABPData  --- OLD CODE
//==============================================================================
/*
void printNvmABPData(nvmABP *pNvmABP){
     uint8_t i;         
     if(verbose){
        pc.printf("\r\n************************************************************"); 
        pc.printf("\r\nnon-volatile memory (nvm) for ABP credendtials:"); 
        pc.printf("\r\nnetworkSessionKey:");      
        for (i = 0; i < 16;i++) 
            pc.printf(" %x",pNvmABP->key_nsk[i]);
        pc.printf("\r\nappicationSessonKey"); 
        for (i = 0; i < 16; i++)
            pc.printf(" %x",pNvmABP->key_aps[i]);        
        pc.printf("\r\nDevAddr");             
        for (i = 0 ; i < 8; i++)
            pc.printf(" %x",pNvmABP->devAdr[i]);        
     }  
     if(verbose)pc.printf("\r\n************************************************************\r\n");      
} 
*/  
//==============================================================================
//getChkSum
//compute chksum
// *pData : pointer to byte data array
// len    : len of byte data array
//==============================================================================
uint8_t getChkSum(uint8_t *pData,uint8_t len ){
    uint8_t i;
    uint8_t chksum= 0;      
    for (i = 0 ; i < len;i++)chksum += pData[i];
    return chksum;    
}   
/*                        
//==============================================================================
//getNvmChkSum
//compute chksum for nvm data; don't include chksum byte in nvm struc
//==============================================================================
uint8_t getNvmChkSum(nvm *pNvm){
    uint8_t i;
    uint8_t chksum= 0;   
    uint8_t *pData = (uint8_t *)pNvm;
    
    for (i = 0 ; i < sizeof(nvm)-1;i++)chksum += pData[i];
    return chksum;    
} 
*/   
//==============================================================================
//getNvmADPChkSum
//compute chksum for nvm data; don't include chksum byte in nvm struc
// TODO: COMBINE TWO CHKSUM PROCEDURES
//==============================================================================
/*
uint8_t getNvmABPChkSum(nvmABP *pNvmABP){    
    uint8_t i;
    uint8_t chksum= 0;   
    uint8_t *pData = (uint8_t *)pNvmABP;
    
    for (i = 0 ; i < sizeof(nvmABP)-1;i++)chksum += pData[i];
    return chksum;       
}
*/
//==============================================================================
//nvmWrite
//write nvmData struc to nvm memory
//==============================================================================
bool nvmWrite(nvm *pNvm){   
   //pNvm->chksum = getNvmChkSum(pNvm);
   uint8_t len = sizeof(pNvm)-1; //doesn't include chksum byte
   pNvm->chksum = getChkSum((uint8_t *)pNvm,len);
   printNmvData(pNvm);
   return dot->nvmWrite(NVM_ADDR_OTAA,pNvm,sizeof(nvm));     
}
/*
//==============================================================================
//nvmWriteABP
//write nvmABPData struc to nvm memory   TODO: WRITE PROCEDUREES
//==============================================================================
bool nvmWriteABP(nvmABP *pNvmABP){   
//   pNvmABP->chksum = getNvmABPChkSum(pNvmABP);
   uint8_t len = sizeof(pNvmABP)-1; //doesn't include chksum byte
   pNvmABP->chksum = getChkSum((uint8_t *)pNvmABP,len);
   if(verbose)pc.printf("\r\n writing ABP creds to nvm:"); 
   printNvmABPData(pNvmABP);
   return dot->nvmWrite(NVM_ADDR_ABP,pNvmABP,sizeof(nvmABP));     
}
*/
//==============================================================================
//nvmRestorekeys
//restore OTAA hard coded keys to nvm and also logdisplay enable/disable
//==============================================================================
bool nvmRestore(nvm *pNvm){
    uint8_t i;
    for (i = 0; i < sizeof(key_AppEUI);i++){
        pNvm->key_AppEUI[i] = key_AppEUI[i];   
    }    
    for (i = 0; i < sizeof(key_AppKey);i++){
        pNvm->key_AppKey[i] = key_AppKey[i];   
    }
    uint8_t len = sizeof(pNvm)-1; //doesn't include chksum byte
    pNvm->chksum = getChkSum((uint8_t *)pNvm,len);
    //pNvm->chksum = getNvmChkSum(pNvm);
    if(verbose)pc.printf("\r\n restoring OTAA backup keys:"); 
    printNmvData(pNvm);
    return dot->nvmWrite(NVM_ADDR_OTAA,pNvm,sizeof(nvm));    
}       
//==============================================================================
//nvmRead
//- read nvmData struc from nvm memory
//- if bad chksum then default to hard code network keys 
//==============================================================================
bool nvmRead(nvm *pNvm){     
   dot->nvmRead(NVM_ADDR_OTAA,pNvm,sizeof(nvm));  
   uint8_t len = sizeof(pNvm)-1; //doesn't include chksum byte
   uint8_t chksum = getChkSum((uint8_t *)pNvm,len);
   //uint8_t chksum = getNvmChkSum(pNvm);
   
   if (chksum == pNvm->chksum){
       logInfo("nvmRead: nvm OTAA chksum ok");           
       return true;
   }    
   return false;
}

//==============================================================================
//nvmReadABP    ------------ OLD CODE
//- read nvmDataABP struc from nvm memory
//- if bad chksum then default to hard code network keys 
//==============================================================================
/*
bool nvmReadABP(nvmABP *pNvmABP){     
   dot->nvmRead(NVM_ADDR_ABP,pNvmABP,sizeof(nvmABP));  
   //uint8_t chksum = getNvmABPChkSum(pNvmABP);
   uint8_t len = sizeof(pNvmABP)-1; //doesn't include chksum byte
   uint8_t chksum = getChkSum((uint8_t *)pNvmABP,len);
   
   if (chksum == pNvmABP->chksum){
       logInfo("nvmRead: ABP chksum ok");           
       return true;
   }    
   return false;   
}
*/
//============================================================================

uint8_t join_network_attempts_wbit() {
    return j_attempts;
}    

bool join_network_wbit(uint8_t nmbAttempts) {
    j_attempts = 0;
    int32_t ret = mDot::MDOT_ERROR;
    
// attempt to join the network
    while (ret != mDot::MDOT_OK)
    {
        j_attempts++;
        logInfo("attempt %d to join network",j_attempts);
        ret = dot->joinNetwork();
        if (ret == mDot::MDOT_OK) return true;
        
        logError("failed to join network %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
        if (j_attempts >= nmbAttempts)
        {
            logInfo("attempts %d to join network exceeds specified attempts %d ",j_attempts,nmbAttempts);   
            return false;
        }               
/*         getNextTxMs() not applicable to U.S. Bands
        // in some frequency bands we need to wait until another channel is available before transmitting again
        uint32_t delay_s = (dot->getNextTxMs() / 1000) + 1;
        if (delay_s < 2) {
            logInfo("waiting %lu s until next free channel", delay_s);
            wait_us(1000*1000*delay_s);
        } else {
            logInfo("sleeping %lu s until next free channel", delay_s);
            dot->sleep(delay_s, mDot::RTC_ALARM, false);
        }        
  */      
    }//while
    return false;
}