#ifndef __MULTICAST_H__
#define __MULTICAST_H__

#include "mbed.h"
#include "mDot.h"
#include "ChannelPlans.h"
#include "MTSLog.h"
#include "MTSText.h"
#include "global.h"

//commands to xdot from loriot for multicast operations
enum CMDS_MULTICAST{
 MULTICAST_CMD_NORMAL             =0, //in normal,Class A state
 MULTICAST_CMD_SPOOF              =1, //xmit fake data to loriot as MULTICAST NODE
 MULTICAST_CMD_GOTOCLASSC         =2, //acknowledge cmd to go to class C, 
 MULTICAST_CMD_GOTOCLASSA         =3, //revert back to classA
 MULTICAST_CMD_SENDFRAGDATA       =4, //send info on last frag download

 };  
 
 //node device states
enum NODE_DEVICE_STATES{
  STATE_CLASSA              = 0,  // send data as normal device on port 1  
  STATE_CLASSC              = 1,  
  STATE_SPOOF               = 2,  //send data in spoof mode
  STATE_MULTICAST_ACK_RCVD  = 3,  // class C cmd rcvd, sent ack
  STATE_MULTICAST_ACK_SENT  = 4,  //  class C cmd ack sent
  STATE_MULTICAST_FRAG_INFO  = 5, // send frag multicat info
  
  
};
static uint8_t port_device         = 1;      //normal device data port 
static uint8_t PORT_MULTICAST_CMD  = 201;    //port for multicast Rx command messages sent via unicast
static uint8_t PORT_MULTICAST_DATA = 202;    //port for multicast Rx data messages sent via multicast


//void multicast_change_creds(bool bNodeX); 
void save_OTAA_session_keys();
bool multicast_change_class(class_switch *sClass);
void multicast_data_process(std::vector<uint8_t> rx_packet);

#endif