#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#include "mbed.h"
//additonal wbit err code returned to proc, standard xdot errs are 0->-13
#define XDOT_ERR_MAX_PAYLOAD   -12    //same as returned by mdot, used if mac data sent and payload aborted
#define XDOT_ERR_FRAME_CNT    -2047
#define XDOT_ERR_I2C_CHKSUM   -2048

#define NVM_ADDR_OTAA          0   //eeprom address for standard OTAA creds
#define NVM_ADDR_ABP          128 //eeprom address for multicast ABP creds

//struc to set radio parameters
typedef struct {  
  uint8_t   maxDataLen;                 //max data length in pkt (read only)
  uint8_t   maxTxPowerdBm;              //max power              (read only) 
  uint8_t   minTxPowerdBm;              //min power              (read only)
  uint8_t   dataRateCurrent;            //dataRateCurrentlyUsed  (read only)
  uint8_t   txPowerCurrent;             //tx power CurrentlyUsed (read only)
  uint8_t   rx1DelayCurrent;            //rx1 delay,sec          (read only)  
  uint8_t   public_network;             //public = true, private = false;
  uint8_t   join_delay;                 //join delay (sec)
  uint8_t   sub_band;                   //network subband #  
  bool      aDR;                        //true if ADR enabled  
  int8_t    antennaGaindBi;             //antenna gain
  bool      txInverted;                 //true if tx inverted
  bool      rxInverted;                 //true if rx inverted
  uint8_t   rxDelay;                    //set rx window delay,sec
  uint8_t   txPower;                    //transmit power
  uint8_t   dataRate;                   //data rate     
  
}xdot_radio_params; 

//struc to set nvm params for OTAA
typedef struct {   
  uint8_t   key_AppEUI[8];              //OTAA key
  uint8_t   key_AppKey[16];             //OTAA key
  bool      bLogOutputOn;               //true if log output on
  uint8_t   chksum;                     //chk to make sure nvm memory ok
 }nvm;

typedef struct {   
  bool      bClassC;                     //true: switch from class C from A, else A from C
  bool      bListen4Multicast;          //if enable xdot listen only for multicast
  uint16_t  maxMulticastSessionTime;    //maximum time to listen for multicast pkts before going back to class A          
  uint8_t   key_nsk[16];                //ABP network seesion key
  uint8_t   key_aps[16];                //ABP application session key
  uint8_t   devAdr[4];                  //device address  

}class_switch;


#endif