#include "mbed.h"
#include "global.h"
#include "commI2C.h"

extern uint8_t buf_xmt[BUFFER_SIZE_I2C];  //outgoing data
extern uint8_t buf_rcv[BUFFER_SIZE_I2C];  //incoming data
I2CSlave slave(PB_9, PB_8);
DigitalInOut wake(PA_0); 

extern Serial pc;
extern bool verbose;  
//#define TEST   
//==============================================================================
// i2c_proc_init
// - init i2c comm to proc
//==============================================================================     
void i2c_proc_init()
{   
    slave.frequency(100000);                   // added DRT NOT NEEDED BY SLAVE????,asb, need this ????
    uint8_t slave_address = 0xA0;                //PROC code uses 7bit address shifted by one so 0xA0 (xdot) => 0x50 (PROC)
    slave.address(slave_address);     
    return;
}
//==============================================================================
// i2c_pulse_wake
// - pulse the wake signal to tell proc that xdot ready for i2c xfr
//==============================================================================     
void i2c_pulse_wake(void){
    //wake.mode(OpenDrain);
    wake.output();
    wake = 1;                            
    wait_us(10000);    //proc uses interrupts on lora_wake, so don't need to wait,just pulse it  
    wake = 0;       //set wake lo  
    wait_us(1000);  
    wake.input();   //go back to input mode   !!! wake pull hi if go back to input mode ???   
    return;
}
//==============================================================================
// i2c_proc_comm
//- set WAKE low to notify proc that's OK to read/write i2c data
//- waits FOREVER  or timeout for proc to write or read i2 data
// - returns point to read or write i2c bfr
//- returns true  if xdot rcvd data into buf_rcv from proc
//          false if xdot wrote  data from buf_xmt to proc
//- before returning sets WAKE hi
//------------------------------------------------------------------------------
// xdot i2c slave operation:
// - xdot does not work correctly as a i2c slave
// - if xdot does not respond to first incoming bytes from master (responseTime)
//    within a defined period the xdot will hang the i2c bus until it is reset
// - the strategy here is sit in a very tight "while loop" polling continually for
//   incoming i2c bytee within the respnseTime
// - time around the "while loop"  must be < "responseTime"
// - "while loop"  is measured at 1.25 usec
// - responseTimes upto 80 usec have been measured to be OK
//------------------------------------------------------------------------------
// timeout:
// - safety mechanism to get xdot back to sleep mode if proc goes unresponsive
// - cpu clock dependant..what mhz is cpu? presently this will give 1.1sec timout before 
// -  0x000fffff gives a 1.1 second timeout
// - after proc wakes xdot from sleep then proc must send an i2c omd within timout
// - once xdot pulses wake to notify proc that i2c ack msg is ready, proc must do i2c read within timeout
// Jan2019: modified to handle large mcast code frags
// - Input parameters:
//   buf_xmt: pointer to buffer containing I2C data for transfer to psco
//   buf_rcv: pointer to buffer continaing I2C data for transfer from psoc
//==============================================================================
I2C_XFR_TYPE i2c_proc_comm(uint8_t *buf_xmt,uint8_t *buf_rcv,uint16_t bufSize)
{
    uint32_t timeout = 0x000fffff;  //1.1second timeout
  
    while(1){
        int i = slave.receive();  
        switch (i) {
            case I2CSlave::ReadAddressed:        //xdot  -> proc                     
                slave.write((char *)buf_xmt,bufSize);                                 
                return I2C_WRITE;            
            case I2CSlave::WriteAddressed:   //xdot <- proc                                                  
                slave.read((char *)buf_rcv,bufSize);                                 
                if (verbose){
                    pc.printf("\n\r Incoming buffer(hex): \n\r");                               
                    int j;
                    for (j = 0; j < BUFFER_SIZE_I2C; j++){
                        pc.printf("%x", buf_rcv[j]);
                        pc.printf(" ");
                 }                           
                }  
                return I2C_READ;                                          
            default:
                return I2C_READ;
        }; //switch  
        
        timeout--;
        if(timeout == 0){
            pc.printf("\r\n I2C TIMEOUT");
            return I2C_WRITE;  //just go to sleep 
        }             
      }; //while  
}                          