/*
 * WaterBit, Inc. ("COMPANY") CONFIDENTIAL
 * Unpublished Copyright (c) 2015-2016 WaterBit, Inc, All Rights Reserved.
 * NOTICE: All information contained herein is, and remains the property of COMPANY. The intellectual and technical concepts contained herein are proprietary to COMPANY and may be covered by U.S. and Foreign Patents, patents in process, and are protected by trade secret or copyright law.
 * 
 * Dissemination of this information or reproduction of this material is strictly forbidden unless prior written permission is obtained from COMPANY.
 *
 * Access to the source code contained herein is hereby forbidden to anyone except current COMPANY employees, managers or contractors who have executed Confidentiality and Non-disclosure agreements explicitly covering such access.
 *
 * The copyright notice above does not evidence any actual or intended publication or disclosure of this source code, which includes information that is confidential and/or proprietary, and is a trade secret, of COMPANY.
 *
 * ANY REPRODUCTION, MODIFICATION, DISTRIBUTION, PUBLICPE RFORMANCE, OR PUBLIC DISPLAY OF OR THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF COMPANY IS STRICTLY PROHIBITED, AND IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS SOURCE CODE AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE, DISCLOSE OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN WHOLE OR IN PART.
 */

#ifndef _COMMI2C_H_
#define _COMMI2C_H_

#include "mbed.h"
#include "global.h"



#define BUFFER_SIZE_I2C     64      //i2c transfer pkt size in ClassA operational mode
#define BUFFER_SIZE_MCAST   160     //i2c transfer pkt size in ClassC code frag mode
#define I2C_MIN_WAIT_DELAY  200     //minimum time between rcv/xmit i2c data and pulsing wake
#define I2C_ACK_PROC       0xff     //first byte of i2c ack msg back to proc
#define I2C_MAX_ACK_DATA     32     //max data bytes accepted from Rx downstream pkt

//cmds to xdot    
enum{
   XDOT_CMD_XMIT_PKT = 1,   //transmit data
   XDOT_CMD_GET_EUI,        //get xdot EUI       
   XDOT_CMD_SET_KEY_X,      //set one of the security keys -> not used ?
   XDOT_CMD_GOTO_SLEEP,     //go to sleep 
   XDOT_CMD_GATEWAY_PING,   //ping gateway for RSSI
   XDOT_CMD_SET_NTWKSESS,   //write/read network session to/from flash      
   XDOT_CMD_SET_RADIO,      //set's radio parameters   
   XDOT_CMD_NVM,            // xdot nvm memory 
   XDOT_CMD_NVM_ABP,        // xdot nvm for multicast ABP creds
   XDOT_CMD_SET_RADIO_CLASS, // change radio class to A or C
   XDOT_CMD_RESTORE_SESSION,// NEW: restore XDOT OTAA session  
   XDOT_CMD_GET_GPS,        // get gps time stamp   
   XDOT_CMD_GET_LORAN_VER,  // get version of loran running in gateway
   XDOT_CMD_UNDEFINED,      //last cmd, not used 
};


enum I2C_XFR_TYPE{
 I2C_READ =0,
 I2C_WRITE
 };   
 
 //structure: upstream pkt for xdot to transmit
 //txData bfr: is located in the struc immediately after dataLen parameter
 //          : this allows extending pkt_upstrm struc as new control parameters are needed 
#define PKT_UPSTRM_RSVD  (BUFFER_SIZE_I2C- (I2C_MAX_ACK_DATA + 7))
typedef struct {   
  uint8_t   cmd;                        //cmd received from proc
  uint8_t   dataLen;                    //datalen found in pkt
  uint8_t   txData[I2C_MAX_ACK_DATA];   //array for tx Data     
  uint8_t   joinAttemps;                //max attempts to join network before quitting 
  uint8_t   appPort;                    //set app port (rev 0307)
  uint8_t   linkThreshCnt;              //set link threshold count, 0 == disable
  uint8_t   bSetAdr;                    //not used
  uint8_t   rxvd[PKT_UPSTRM_RSVD];      //rserved filler bytes
  uint8_t   chksum;                     //chksum of all previous, last byte in pkt
 }pkt_upstrm;
//structure: results returned to proc  of upstream data transmit
typedef struct {
  uint8_t   ack;                        //ack header response
  uint8_t   cmd;                        //cmd received from proc
  uint8_t   dataLen;                    //datalen found in pkt
  uint8_t   bXmitAttempted;             //true if xmit attempted, (fail of pkt len too big)  
  uint8_t   joinAttempts;               //# of join attempts before join occured, if bJoined=0 this = max attempts
  uint8_t   bJoined;                    //true if successfully joined  
  uint8_t   bAck;                       //true if ack return from xmit
  uint8_t   bRx1;                       //true if rx1 return
  uint8_t   bAckdata;                   //true if rx data
  int8_t    rssi;                       //last rssi, 0 if no rx1/2 ack --> old, don't use, bad if rssi < -128
  uint8_t   rxLen;                      //length of returned rxdata
  uint8_t   rxData[I2C_MAX_ACK_DATA];   //array for rx Data    
  int16_t   mdot_ret;                   //mdot return code after calling send function
  uint8_t   chksum_err;                 //1 if chksum err on proc upstream pkt
  int8_t    snr;                        //last snr, 0 if no rx1/2 ack --> old, don't use, bad if snr < -128
  uint8_t   appPort;                    //rcvd app port (rev 0309)
  int16_t   rssi2;                      //16 bit rssi because rssi can be < -128
  int16_t   snr2;                       //16 bit snr if  snr < -128
  uint8_t   rsvd[10];                   //reserved for future use
}pkt_ack;
//structure: results returned to proc for eui and api_level
//v0307: eui pkt now used to read/set radio params also
typedef struct {
  uint8_t   ack;                        //ack header response
  uint8_t   cmd;                        //cmd received from proc
  uint8_t   dataLen;                    //datalen found in pkt
  uint8_t   euiData[16];                //eui 
  uint8_t   apiLvlData[4];              //api level 
  uint8_t   verLvlData[4];              //ver level   
}pkt_eui;
//structure: results returned to proc for gps cmd
typedef struct {
  uint8_t   ack;                        //ack header response
  uint8_t   cmd;                        //cmd received from proc
  uint8_t   dataLen;                    //datalen found in pkt
  uint8_t   gpsData[8];                 //gps time: 64 bit 
  char      lorawanVer[16];              //lorawan version string
}pkt_gps;

//--------------------------------------------------------------------------
//structure: cmd structure to proc for setting radio parameters
//upstream pkt struc
typedef struct {  
  uint8_t   cmd;                        //cmd received from proc
  uint8_t   dataLen;                    //datalen found in pkt  
  bool      bSetParams;                 //if true then set and save variable params to nvm; false=> read params
  xdot_radio_params params;
}pkt_setradioup;

//downstream pkt struc
//structure: cmd structure to proc for setting radio parameters
typedef struct {
  uint8_t   ack;                        //ack header response
  uint8_t   cmd;                        //cmd received from proc
  uint8_t   dataLen;                    //datalen found in pkt  
  xdot_radio_params params;
}pkt_setradiodwn;
//--------------------------------------------------------------------------
//nvm ptks for OTAA creds
enum {
     XDOT_NVM__READ = 0,
     XDOT_NVM_SET = 1,
     XDOT_NVM_RESTORE = 2,
};  
//structure: cmd structure to proc for setting nvm parameters
//upstream pkt struc
typedef struct {  
  uint8_t   cmd;                        //cmd received from proc
  uint8_t   dataLen;                    //datalen found in pkt  
  uint8_t   nvm_option;                 //read,write,restore  
  nvm       nvmData;
}pkt_setnvmup;
//dwnstream pkt struc
typedef struct {  
  uint8_t   ack;                        //ack header response
  uint8_t   cmd;                        //cmd received from proc    
  uint8_t   dataLen;                    //datalen found in pkt  
  uint8_t   bChkSumOK; 
  nvm       nvmData;
}pkt_setnvmdwn;
//--------------------------------------------------------------------------
//ptks for class A/B radio change
//--------------------------------------------------------------------------
//upstream pkt struc
typedef struct {  
  uint8_t       cmd;                        //cmd received from proc
  uint8_t       dataLen;                    //datalen found in pkt  
  class_switch  classData;
}pkt_setClassUp;
//dwnstream pkt struc
typedef struct {  
  uint8_t   ack;                        //ack header response
  uint8_t   cmd;                        //cmd received from proc    
  uint8_t   dataLen;                    //datalen found in pkt  
  bool      bSwitched;                  //1 = switched OK  
}pkt_setClassDwn;

//structure: results returned to proc network session
typedef struct {
  uint8_t   ack;                        //ack header response
  uint8_t   cmd;                        //cmd received from proc
  uint8_t   dataLen;                    //datalen found in pkt
  uint8_t   bSetNetwrk;                 //1 if wrote network session, 0 if read   
}pkt_ntwrk;

//structure: results returned to proc of gateway ping
typedef struct {
  uint8_t   ack;                        //ack header response
  uint8_t   cmd;                        //cmd received from proc
  uint8_t   dataLen;                    //datalen found in pkt
  int8_t   status;                      //ping status return, 0 = success
  int8_t   rssi;                        //rssi that gateway heard from node
  int8_t   snr;                         //snr  that ....
}pkt_ping;




typedef struct {
  uint8_t   ack;                        //ack header response
  uint8_t   cmd;                        //cmd received from proc
  uint8_t   dataLen;                    //datalen found in pkt
  uint8_t   rxData[I2C_MAX_ACK_DATA];   //Data    
}data_ack;


void i2c_proc_init();
//void i2c_wait4wake_lo(void);
void i2c_pulse_wake(void);
//I2C_XFR_TYPE i2c_proc_comm();  //ols
I2C_XFR_TYPE i2c_proc_comm(uint8_t *buf_xmt,uint8_t *buf_rcv,uint16_t bufSize);

#endif
