#ifndef __RADIO_EVENT_H__
#define __RADIO_EVENT_H__

#include "dot_util.h"
#include "mDotEvent.h"
#include "multicast.h"

extern bool bRxDone;              //true if callback function RxDone() triggered
extern bool bDownLinkCntrFail;   //true if callback function RxDone() triggered and bad downlink frame count


class RadioEvent : public mDotEvent
{
 
private:
    bool downstream_packet_received; 
    std::vector<uint8_t> received_packet;
 
public:
    uint8_t port;
    RadioEvent() {
        downstream_packet_received = false;    
    }
 
    virtual ~RadioEvent() {}
 
    std::vector<uint8_t> get_downstream_packet() {        
        downstream_packet_received = false;
        return received_packet; 
    }
 
    bool is_packet_received() {
        //printf("  ----------------------------downstream_packet_received %d\n\r",downstream_packet_received);                                
        return downstream_packet_received;    
    }
    
    
/**
 * Fired when radio has received a packet, packet is not validated
 * chk's if downlink counter is >= getDownLinkCounter() => if not, something has reset the donwnlink frame counter -> should not happen!
 * @param payload received bytes
 * @param size number of received bytes
 * @param rssi of received packet
 * @param snr of received packet
 * @param ctrl Downlink control field of packet
 * @param slot rx window packet was received
  * payload bytes 6-7 are downlink counter
 */
    virtual void RxDone(uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr, lora::DownlinkControl ctrl, uint8_t slot){
        int i;
        int32_t fCntDown = 0;
        uint32_t downlinkcounter = dot->getDownLinkCounter(); 
        bRxDone = true;    //callback entered                               
        fCntDown =   (payload[7] << 8) +  payload[6];            
        if (fCntDown < downlinkcounter){
            printf("\r\nRX FRAME ERR: RxDone payload:");
            for (i=0; i< size;i++)printf(" %x",payload[i]);                                                                                                                                                  
            bDownLinkCntrFail = true;;
            printf(" Downlink counter:%d DownLinkCntFail:%d\n\r",downlinkcounter,fCntDown);                                
         }   
    }
  
    
/*===================================================================================================
 * MAC layer event callback prototype.
 *
 * \param [IN] flags Bit field indicating the MAC events occurred
 * \param [IN] info  Details about MAC events occurred
=====================================================================================================*/
    virtual void MacEvent(LoRaMacEventFlags* flags, LoRaMacEventInfo* info) { 
        if (mts::MTSLog::getLogLevel() == mts::MTSLog::TRACE_LEVEL) {
            std::string msg = "OK";
            switch (info->Status) {
                case LORAMAC_EVENT_INFO_STATUS_ERROR:
                    msg = "ERROR";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_TX_TIMEOUT:
                    msg = "TX_TIMEOUT";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_RX_TIMEOUT:
                    msg = "RX_TIMEOUT";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_RX_ERROR:
                    msg = "RX_ERROR";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_JOIN_FAIL:
                    msg = "JOIN_FAIL";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_DOWNLINK_FAIL:
                    msg = "DOWNLINK_FAIL";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_ADDRESS_FAIL:
                    msg = "ADDRESS_FAIL";
                    break;
                case LORAMAC_EVENT_INFO_STATUS_MIC_FAIL:
                    msg = "MIC_FAIL";
                    break;
                default:
                    break;
            }
            logTrace("Event: %s", msg.c_str());
 
            logTrace("Flags Tx: %d Rx: %d RxData: %d RxSlot: %d LinkCheck: %d JoinAccept: %d",
                     flags->Bits.Tx, flags->Bits.Rx, flags->Bits.RxData, flags->Bits.RxSlot, flags->Bits.LinkCheck, flags->Bits.JoinAccept);
            logTrace("Info: Status: %d ACK: %d Retries: %d TxDR: %d RxPort: %d RxSize: %d RSSI: %d SNR: %d Energy: %d Margin: %d Gateways: %d",
                     info->Status, info->TxAckReceived, info->TxNbRetries, info->TxDatarate, info->RxPort, info->RxBufferSize,
                     info->RxRssi, info->RxSnr, info->Energy, info->DemodMargin, info->NbGateways);
        }
        if (flags->Bits.Rx) {            
            logDebug("Rx %d bytes", info->RxBufferSize);
            if (info->RxBufferSize > 0) {
                int i;
                received_packet.clear();
                for (i=0; i<(info->RxBufferSize); i++) received_packet.push_back(info->RxBuffer[i]);                                
                //printf(" Rx incoming data: %s\r\n", mts::Text::bin2hexString(info->RxBuffer,info->RxBufferSize).c_str());
                downstream_packet_received = true;
                port = info->RxPort;   
                if (port == PORT_MULTICAST_DATA) {
                    multicast_data_process(received_packet);  //mcast code frag packet
                }                                                       
            } // if info->RxBufferSize >            
        } //if (flags->Bits.Rx) 
        else {
            downstream_packet_received = false;           
        }        
    }
};

#endif

