#include "mbed.h"
#define DIST 15
#define DEBUG 0

// Global variables
Serial pc(USBTX, USBRX);
AnalogIn Ain(A3);
Timer timer1;

float IrSensor;
float dist_new = 0.0;
float dist_old = 0.0;
int elapsed_time = 0;
// Prototype
float distance(float);

// main function
int main(void)
{
    pc.printf("Debut du programme...\n");
    timer1.start();
    
    while(1) {
        IrSensor=Ain.read();        // IrSensor belongs to [0.0; 1.0]
        //pc.printf("Distance en cm : %.1f \n\r",distance(IrSensor*3.3)); 
#if DEBUG
        pc.printf("%f \n\r",IrSensor*3.3);  // Output voltage from 0 to 3.3V
        pc.printf("Distance en cm : %.1f \n\r",distance(IrSensor*3.3));        
#endif  
        dist_old = dist_new;
        dist_new = distance(IrSensor*3.3);     
        if ((dist_old > 40) && ((dist_new> 0) && (dist_new < 30)))
        {
            elapsed_time = timer1.read_ms();
            timer1.reset();
            pc.printf("************* %2.2f sec *************\r\n",(float)elapsed_time/1000.0);      
            wait_ms(1000);      
        }        
        wait(0.1);
        float val = timer1.read_ms()/1000.0;
        pc.printf("%3.2f sec\r",val); 
        
    }
    timer1.stop();
}

// Calcul de la distance 
// Entre 20 et 80cm, on peut approximer la distance avec r=24/(V-0,1)
// r = distance en cm
// V = tension lue
float distance(float tension)
{
    return(24.0/(tension - 0.1));
}

