#include "mbed.h"

Ticker      tick10ms;
DigitalIn   sw(dp26);
PwmOut      pwmled(dp24);
DigitalOut  myled(LED1);

Serial pc(dp16, dp15);

static uint8_t sw_state = 0;
static bool sw_on = 0;

/* 10ms間隔で呼び出すハンドラ */
void tick10ms_proc(void)
{
    /* 直近8回のスイッチON/OFF状態を保持 */
    sw_state <<= 1;
    sw_state &= 0xfe;
    sw_state |= (sw & 0x01);

    switch (sw_state) {
        case 0x00:  /* 8回連続OFF */
            sw_on = 0;
            break;
        case 0xff:  /* 8回連続ON */
            sw_on = 1;
            break;   
    }
}

int main() {
    uint8_t led_lv = 0;
    uint8_t prev_sw = 0;
    uint8_t sw_val = 0;
    
    myled = 0;
    
    pc.baud(9600);
    pc.printf("Start.\r\n");
    
    /* 10ms間隔のハンドラを登録 */
    tick10ms.attach_us(tick10ms_proc, 10000);

    /* PWMの周波数を10kHzに設定 */
    pwmled.period(0.01);
    pwmled = 0.0;

    while(1) {
        /* スイッチ状態を読み出し */
        __disable_irq();
        sw_val = sw_on;
        __enable_irq();
        
        /* スイッチON→OFFに変化 */
        if ((prev_sw == 1) && (sw_val == 0)) {
            led_lv = (led_lv + 1) % (5 + 1);    //LED出力を6段階に変化させる
            pwmled = (float)led_lv * 0.2;
            
            pc.printf("PUSHED: led_lv=%d\r\n", led_lv);
        }
        prev_sw = sw_val;
    }
}
