/*
 * Simple monophonic synthesizer
 * auther: alaif.
 */
#include "mbed.h"
#include "USBMIDI.h"

/* MIDI note no -> FREQ */
#include "math.h"
#define NOTE2FREQ(note) (440 * pow(2, ((note - 69) / 12.0f)))

/* HARDWARE Config */
PwmOut sp1(p21);
DigitalOut led_ready(LED1);
DigitalOut led_noteon(LED2);

//NOTE ON event
void note_on(int note, int vel)
{
    if (vel != 0) {
        sp1.period(1.0f / NOTE2FREQ(note));         //Set freq
        sp1.write(0.5f);                            //SQUARE WAVE ON
        led_noteon = 1;
    } else {
        sp1.write(0.0f);                            //SQUARE WAVE OFF
        led_noteon = 0;
    }
}

//NOTE OFF event
void note_off()
{
    sp1.write(0.0f);
    led_noteon = 0;
}

//Recv midi message handler.
void do_message(MIDIMessage msg)
{
    int key = msg.key();
    switch (msg.type()) {
        case MIDIMessage::NoteOnType:
            note_on(key, msg.velocity());
            break;
        case MIDIMessage::NoteOffType:
            note_off();
            break;
    }
}

/* Main */
USBMIDI midi;
int main() {
    led_ready = 0;          
    midi.attach(do_message);    // call back for messages received    
    led_ready = 1;
    
    while (1) {}
}
