#include "mbed.h"

PwmOut myled1(LED1);
PwmOut myled2(LED2);
PwmOut myled3(LED3);
PwmOut myled4(LED4);

// Knight Rider lights.
// Smoothly transistion between the 4 LEDs to test out the mbed. :)
int main() {
    float rate = 0.002;
    float endHangtime = 0.1;
    float brightness = 0.9;
    int i = 0;
    while(1) {
        for(i=0; i<=100; i++){
            myled1 = (100-i)/100.0*brightness;
            myled2 = i/100.0*brightness;
            wait(rate);
        }
        for(i=0; i<=100; i++){
            myled2 = (100-i)/100.0*brightness;
            myled3 = i/100.0*brightness;
            wait(rate);
        }
        for(i=0; i<=100; i++){
            myled3 = (100-i)/100.0*brightness;
            myled4 = i/100.0*brightness;
            wait(rate);
        }
        // all the way to one side, briefly pause to exagerate.
        wait(endHangtime);
        for(i=0; i<=100; i++){
            myled4 = (100-i)/100.0*brightness;
            myled3 = i/100.0*brightness;
            wait(rate);
        }
        for(i=0; i<=100; i++){
            myled3 = (100-i)/100.0*brightness;
            myled2 = i/100.0*brightness;
            wait(rate);
        }
        for(i=0; i<=100; i++){
            myled2 = (100-i)/100.0*brightness;
            myled1 = i/100.0*brightness;
            wait(rate);
        }
        // all the way to other side, briefly pause to exagerate.
        wait(endHangtime);
    }
}
