
#include "mbed.h"
#include "uart1.h"
#include "HMC6352.h"

//extern Serial pc;
extern Serial device2;
extern HMC6352 compass;
extern BusOut mbedleds;
extern DigitalOut led1; 
extern DigitalOut led2;
extern DigitalOut led3;
extern DigitalOut led4;

extern uint8_t state;
extern uint8_t hold_flag;

int diff;
uint16_t ultrasonicVal[4];
uint8_t direction;
uint8_t Distance;
uint8_t IR_found;
uint8_t xbee;

void dev_rx()
{
    static uint8_t count = 0;
    static uint8_t RecData[RECEIVE_DATA_NUM];
    static uint8_t last_data;
    
    RecData[count] = device2.getc();
    
    if(RecData[KEY] == KEYCODE){
        count++;
    }else{
        count = 0;
    }
    if(count >= RECEIVE_DATA_NUM){
        if(RecData[CHECK] == CHECKCODE){
            //mbedleds = 15;
            
            if((RecData[DIRECTION] <= 15) || (RecData[DIRECTION] == 200)){
                direction = RecData[DIRECTION];
            }
            if(RecData[DISTANCE] <= 180){
                Distance = RecData[DISTANCE];
            }
            
            ultrasonicVal[0] = (int)((RecData[SONIC1_1] + (RecData[SONIC1_2] << 8)) / 10.0);
            if(ultrasonicVal[0] == 6553)ultrasonicVal[0] = 0xFFFF;
            ultrasonicVal[1] = (int)((RecData[SONIC2_1] + (RecData[SONIC2_2] << 8)) / 10.0);
            if(ultrasonicVal[1] == 6553)ultrasonicVal[1] = 0xFFFF;
            ultrasonicVal[2] = (int)((RecData[SONIC3_1] + (RecData[SONIC3_2] << 8)) / 10.0);
            if(ultrasonicVal[2] == 6553)ultrasonicVal[2] = 0xFFFF;
            ultrasonicVal[3] = (int)((RecData[SONIC4_1] + (RecData[SONIC4_2] << 8)) / 10.0);
            if(ultrasonicVal[3] == 6553)ultrasonicVal[3] = 0xFFFF;
            
            if((RecData[IR_FOUND] == 0) || (RecData[IR_FOUND] == 1)){
                IR_found = RecData[IR_FOUND];
            }
            xbee = RecData[XBEE];
            
            
            //pc.printf("%f\t%f\t%f\t%f\n",ultrasonicVal[0],ultrasonicVal[1],ultrasonicVal[2],ultrasonicVal[3]);
            //pc.printf("%d\n",xbee);
            //pc.printf("%d\n",IR_found);
            
            diff = last_data - Distance;
            last_data = Distance;
        }
        count = 0;
    }  
}

void dev_tx()
{
    static uint8_t count2 = 0;
    static uint8_t SendData[SEND_DATA_NUM];
    
    if(count2 >= SEND_DATA_NUM){
        SendData[KEY2]     = KEYCODE2;
        SendData[DATA1]    = ((int)(compass.sample())) >> 8 ;
        SendData[DATA2]    = (int)(compass.sample());
        SendData[DATA3]    = state;
        SendData[DATA4]    = 1;
        SendData[CHECK2]   = CHECKCODE2;
        
        count2 = 0;
        
    }
    device2.putc(SendData[count2]);
    
    count2++;
}