
#include "mbed.h"
#include "uart1.h"
#include "HMC6352.h"

extern Serial device2;
extern HMC6352 compass;

extern uint8_t state;

float ultrasonicVal[4];
uint8_t direction;
uint8_t Distance;
uint8_t IR_found;
uint8_t xbee;

void dev_rx()
{
    static uint8_t count;
    static uint8_t RecData[RECEIVE_DATA_NUM];
    
    RecData[count] = device2.getc();
    
    if(RecData[KEY] == KEYCODE){
        count++;
    }else{
        count = 0;
    }
    if(count >= RECEIVE_DATA_NUM){
        if(RecData[CHECK] == CHECKCODE){
            //mbedleds = 1;
            direction = RecData[DIRECTION];
            Distance = RecData[DISTANCE];
            ultrasonicVal[0] = (RecData[SONIC1_1] + (RecData[SONIC1_2] << 8)) / 10.0;
            ultrasonicVal[1] = (RecData[SONIC2_1] + (RecData[SONIC2_2] << 8)) / 10.0;
            ultrasonicVal[2] = (RecData[SONIC3_1] + (RecData[SONIC3_2] << 8)) / 10.0;
            ultrasonicVal[3] = (RecData[SONIC4_1] + (RecData[SONIC4_2] << 8)) / 10.0;
            xbee = RecData[XBEE];
            IR_found = xbee;
        }
        count = 0;
    }  
}

void dev_tx()
{
    static uint8_t count2;
    static uint8_t SendData[SEND_DATA_NUM];
    
    //mbedleds = 2;
    
    if(count2 >= SEND_DATA_NUM){
        SendData[KEY2]     = KEYCODE2;
        SendData[DATA1]    = ((int)(compass.sample())) >> 8 ;
        SendData[DATA2]    = (int)(compass.sample());
        SendData[DATA3]    = state;
        SendData[DATA4]    = 1;
        SendData[CHECK2]   = CHECKCODE2;
        
        count2 = 0;
        
    }
    device2.putc(SendData[count2]);
    
    count2++;
}