
#include "mbed.h"
#include "uart1.h"

extern Serial device;
extern BusOut mbedleds;
//extern Serial pc;
extern int direction;
extern int Distance;
extern int IR_found;
extern int AveDistance;
extern uint16_t ultrasonicVal[4];

uint8_t xbee;
uint8_t data[4];
int irDistance[6];

extern uint8_t data2[5];

void dev_rx()
{   
    static uint8_t count2 = 0;
    static uint8_t RecData[RECEIVE_DATA_NUM];
    
    RecData[count2] = device.getc();
    
    if(RecData[KEY2] == KEYCODE2){
        count2++;
    }else{
        count2 = 0;
    }
    if(count2 >= RECEIVE_DATA_NUM){
        if(RecData[CHECK2] == CHECKCODE2){
            //mbedleds = 15;
            data[0] = RecData[DATA1];
            data[1] = RecData[DATA2];
            data[2] = RecData[DATA3];
            data[3] = RecData[DATA4];
            irDistance[0] = (RecData[DISTANCE1] << 8) + RecData[DISTANCE1_2];
            irDistance[1] = (RecData[DISTANCE2] << 8) + RecData[DISTANCE2_2];
            irDistance[2] = (RecData[DISTANCE3] << 8) + RecData[DISTANCE3_2];
            irDistance[3] = (RecData[DISTANCE4] << 8) + RecData[DISTANCE4_2];
            irDistance[4] = (RecData[DISTANCE5] << 8) + RecData[DISTANCE5_2];
            irDistance[5] = (RecData[DISTANCE6] << 8) + RecData[DISTANCE6_2];
            //pc.printf("%d\n",data[2]);
        }
        count2 = 0;
    }  
}

void dev_tx()
{
    static uint8_t count = 0;
    static uint8_t SendData0[SEND_DATA_NUM];
    
    if(count >= SEND_DATA_NUM){
        xbee = data2[0];
        SendData0[KEY]      = KEYCODE;
        SendData0[DIRECTIONN] = direction;
        SendData0[DISTANCE] = AveDistance;
        SendData0[SONIC1_1] = ultrasonicVal[0];
        SendData0[SONIC1_2] = (ultrasonicVal[0] >> 8);
        SendData0[SONIC2_1] = ultrasonicVal[1];
        SendData0[SONIC2_2] = (ultrasonicVal[1] >> 8);
        SendData0[SONIC3_1] = ultrasonicVal[2];
        SendData0[SONIC3_2] = (ultrasonicVal[2] >> 8);
        SendData0[SONIC4_1] = ultrasonicVal[3];
        SendData0[SONIC4_2] = (ultrasonicVal[3] >> 8);
        SendData0[IR_FOUND] = IR_found;
        SendData0[XBEE]     = xbee;
        SendData0[CHECK]    = CHECKCODE;
        
        //pc.printf("%d\t%d\t%d\t%d\n",SendData0[DIRECTIONN],SendData0[DISTANCE],SendData0[IR_FOUND],SendData0[CHECK]);
        
        count = 0;
    }
    device.putc(SendData0[count]);
    
    count++;
}