#include "mbed.h"
 
I2C i2c(p9, p10);        // sda, scl
Serial pc(USBTX, USBRX); // tx, rx

#define ADDR 0x14   // define the I2C Address

int main() {
    char cmd[4];
    while(1) {
        cmd[0] = 0x0;            // pointer to command register
        cmd[1] = 0x51;           // Start ranging, results in cm
        i2c.write(ADDR, cmd, 2); // Send command string
 
        wait(0.07);              // Could also poll, 65ms is typical
 
        // Set pointer to location 2 (first echo)
        cmd[0] = 0x2;
        i2c.write(ADDR, cmd, 1);
        i2c.read(ADDR, cmd, 2); // read the two-byte echo result
 
        // print the ranging data to the screen
        float echo = 0.01 * ((cmd[0] << 8) + cmd[1]);
        pc.printf("Range = %.2f\n", echo);
        wait(0.1);
    }
}