#include "FileHandler.h"
#ifndef DEBUG
//#define DEBUG
#endif
LocalFileSystem local("local");

FileHandler::FileHandler()
{
    fullpath = NULL;
    filename = NULL;
    suffix = NULL;
    fp = NULL;
    file_size = 0;
}
FileHandler::~FileHandler()
{
    if (fullpath != NULL) free(fullpath);
    if (fp != NULL) fclose(fp);
}

FILE* FileHandler::open
(   const char* arg_filepath,
    const char* arg_mode
)
{
    FILE *tmp;

    //////printf("\r\n"
    //       "fp: %d@FileHandler::open\r\n", fp);
    if (fullpath != NULL) free(fullpath);
    fullpath = (char*)malloc(sizeof(char) * (strlen("/local/") + strlen(arg_filepath) + strlen("index.htm") + 1));
    //////printf("fp: %d@FileHandler::open\r\n", fp);

    //  Path formatting
    if (arg_filepath[0] == '/') {
        sprintf(fullpath, "/local/%s", arg_filepath + 1);
    } else {
        sprintf(fullpath, "/local/%s", arg_filepath);
    }
    //  if the argument has no file name but directory, defalt settiing.
    if (fullpath[strlen(fullpath) - 1] == '/')
        strcat(fullpath, "index.htm");
    //  store the file name part to a pointer
    filename = strrchr(fullpath, '/');
    if(filename != NULL)    filename++; //  remove '/' and just get only the file name.
    //  store the suffix part to a pointer
    suffix = strchr(filename, '.');
    if(suffix   != NULL)    suffix++;   //  remove '.' and just get only the suffix.
#ifdef DEBUG
    //////printf("full path: %s\r\nfilename: %s\r\nsuffix: %s\r\n", getFullpath(), getFilename(), getSuffix());
#endif
    fp = fopen(fullpath, arg_mode);
#ifdef DEBUG
    //////////printf("file opened@FileHandler::open\r\n");
#endif
    //  mesure file size
    file_size = 0;
    tmp = fp;
    if(tmp != NULL ) {
        ////printf("\r\nfile content\r\n");
        int ctmp;
        while(1) {
            ctmp = fgetc(tmp);
            if(ctmp != EOF) {
                //////printf("%c", ctmp);
                file_size++;
            } else {
                //////printf("[EOF]\r\n");
                break;
            }
        }
        ////printf("file size: %d\r\n", file_size);
        if(fseek(tmp, 0L, SEEK_SET) != 0) {
            //////printf("fseek failed\r\n");
        }
    } else {
        file_size = 0;
    }

    return fp;
}
int FileHandler::close()
{
    int tmp;

    if(fp != NULL) {
        tmp = fclose(fp);
        fp = NULL;
        return tmp;
    } else {
        return 1;
    }
}

int FileHandler::getc()
{
    int tmp = fgetc(fp);
#ifdef DEBUG
    if(0x20 < tmp && tmp < 0x7e)
        printf("%c", tmp);
    else if (tmp == '\r')
        printf("\r");
    else if (tmp == '\n')
        printf("\n");
    else
        printf("@");
#endif
    return tmp;
}
bool FileHandler::arrival()
{
    return (bool)fp;
}
bool FileHandler::atEOF()
{
    return (bool)feof(fp);
}
bool FileHandler::hasError()
{
    return (bool)ferror(fp);
}
char *FileHandler::getFullpath()
{
    return fullpath;
}
char *FileHandler::getFilename()
{
    return filename;
}
char *FileHandler::getSuffix()
{
    return suffix;
}
int FileHandler::getFileSize()
{
    return file_size;
}