#ifndef WS_SERVER_H
#define WS_SERVER_H

#include "mbed.h"
#include "EthernetInterface.h"
#include "base64.h"
#include "sha1.h"
#include "ResponseMessenger.h"
#include "FileHandler.h"
#include "string.h"
#include <stdlib.h>
using namespace std;

/** Websocket Server class
 *
 * This is the class to make a mbed a simple HTTP Server.
 */
class WSS
{
public:
    /** Constractor
     *  @bref Default constractor
     *  RxBufferSize = 1024  (Default)
     *  PortNumber   = 8085  (Default)
     */
    WSS();
    /** Constractor
     *  @param (uint32_t)RxBufferSize is buffer size for recieving data from clients.
     *  @param (uint32_t)PortNumber is port number of tcp port this server uses.(defulat 8085)
     */
    WSS(uint32_t RxBufferSize, uint32_t PortNumber = 8085);
    
    ~WSS();
    
    /** Websocket SERVER Initialization.
     *  @return result of init() as boolean.
     *  @retval TRUE SACCESS
     *  @retval FALSE
     */
    bool init();
    
    /** Make sure whether the server (actually the tcp server) is listening
     *  @retyrn whther the server is listening
     *  @retval TRUE the server is listening.
     *  @retval FALSE the server is no longer listening.
     */
    bool isListening(); 
    
    
    /** Run the surver service while listening flag is true.
     */
    void run();
    
    /** Make sure whether there are any data.
     *  @return whtere data existing
     *  @retval TRUE recived data exist
     *  @retval FALSE no data recived
     */
    bool isReadable();
    
    /** Read recieved data which are unmasked.
     *  @return Unmasked octed data
     */
    int8_t getRxData();
    
    /** Clear Rx Buffer
     */
    void discardRxBuffer();
    
    
    template<typename T> void txMessage(T arg_msg);
    void txClosing(int arg_status_code, const char* arg_msg);
    void txPing();
    void txPong();
    
private:
    //
    //  Handlers
    //
    EthernetInterface   m_eth;    //  Eternet
    TCPSocketServer     m_tcpsvr; //  TCP server
    TCPSocketConnection m_tcpcon; //  TCP server connection clerk
    ResponseMessenger   m_msger;
    //
    //  Param
    //
    bool        m_ListeningFlag;
    bool        m_DiscontiuanceFlag;
    bool        m_EODFlag;
    const uint32_t  m_RxBufferSize;
    uint8_t*         m_RxBuffer;     // = new uint8_t(RxBufferSize = 1024);
    const uint32_t  m_PortNumber;
    //  bits (not bytes) is commented to right
    uint8_t      m_FIN_RSV;          //[1bit x4(FIN, RSV1, RSV2, RSV3)]
    uint8_t      m_Opcode;           //[4bits]
    uint8_t      m_Mask;             //[1bit]
    uint64_t     m_PayloadLen;       //=x+y bytes[7 xor 7\16 xor 7\64 bits]
    uint8_t      m_Masking_key[4];      //[0-4 bytes]
    uint8_t*     m_PayloadData;      //[x+y bytes]
    uint32_t     m_ExtensionLen;     //=x   bytes
    uint64_t     m_ApplicationLen;   //=y   bytes
    uint64_t     m_restAppDataLen;   //=m_ApplicationLen - already read data len
    enum OpCode{
        cont = 0, txt = 1, bin = 2, close = 8, ping = 9, pong = 10
    };
    OpCode      m_FrameOpcode;   //data mode of payload
    
    //
    //  Functions
    //
    bool handshake();
    //bool startCom();
    int8_t rxMessage();
};

#endif