#ifndef TRP105F_SPLINE_SPI_WRAPPER_H
#define TRP105F_SPLINE_SPI_WRAPPER_H

#include "mbed.h"
#include "TRP105F_Spline.h"
#include "CODE_SELECTIVE.h"

class SPI_TRP105FS
{
private:
    unsigned int channel;   //SPI cs number
    unsigned int nsample;   //number of sumples
    TRP105FS trp;
    char filename[13];      //name of file chalibration results saved

public:
    static SPI spi;                // mosi(out), miso(in), sclk(clock)
    static DigitalOut cs;          // cs (the chip select signal)
    
    SPI_TRP105FS();
    SPI_TRP105FS(unsigned int arg_ch);
    SPI_TRP105FS(unsigned int arg_ns, unsigned int arg_ch);
    
    static int  ADread(int channel);
    
    void setSample(unsigned short arg_x);

    void calibrate();

    unsigned short getDistance();

    unsigned int getChannel();

    unsigned int getNsample();

    void savedata();

    void loaddata();

    void printCalibrationiLOG();
};
#endif