#include "TRP105FS_SPIWrapper.h"

//
//  Make instance of static member
//
SPI
SPI_TRP105FS::spi(p5, p6, p7);  // mosi(out), miso(in), sclk(clock)

DigitalOut
SPI_TRP105FS::cs(p8);           // cs (the chip select signal)

//
//  For SPI, Define static method
//
int
SPI_TRP105FS::ADread(int channel)
{
    int command_high=0x06|((channel&0x04)>>2);
    int command_low=(channel&0x03)<<14;
    __disable_irq(); // 割り込み禁止
    cs = 0;
    spi.write(command_high);
    int resultbyte=spi.write(command_low) & 0xfff;
    cs = 1;
    __enable_irq(); // 割り込み許可
    return(resultbyte);
}

//
//  Define Constructor
//
SPI_TRP105FS::SPI_TRP105FS()
    :channel(0)
    ,nsample(5)
    ,trp(TRP105FS(nsample))
    ,filename("\0")
{}

SPI_TRP105FS::SPI_TRP105FS(unsigned int arg_ch)
    :channel(arg_ch)
    ,nsample(5)
    ,trp(TRP105FS(nsample))
    ,filename("\0")
{}

SPI_TRP105FS::SPI_TRP105FS(unsigned int arg_ns, unsigned int arg_ch)
    :channel(arg_ch)
    ,nsample(arg_ns)
    ,trp(TRP105FS(nsample))
    ,filename("\0")
{}

void
SPI_TRP105FS::setSample(unsigned short arg_x)
{
    trp.setSample(arg_x, (unsigned short)ADread(channel));
}

void
SPI_TRP105FS::calibrate()
{
    trp.calibrate();
}

unsigned short
SPI_TRP105FS::getDistance()
{
    return trp.getDistance((unsigned short)ADread(channel));
}

unsigned int
SPI_TRP105FS::getChannel()
{
    return channel;
}

unsigned int
SPI_TRP105FS::getNsample()
{
    return nsample;
}

#if defined(HAS_LOCAL_FILE_SYSTEM)
void
SPI_TRP105FS::savedata()
{
    if (filename[0] == '\0')
        sprintf(filename, "SENSOR%02d.SAV", channel);
    trp.saveSetting(filename);
}

void
SPI_TRP105FS::loaddata()
{
    if (filename[0] == '\0')
        sprintf(filename, "SENSOR%02d.SAV", channel);
    trp.loadSetting(filename);
}
void
SPI_TRP105FS::printCalibrationiLOG()
{
    char lfilename[13];
    
    sprintf(lfilename, "ADLOG%2d.TXT", channel);
    trp.printOutData(lfilename);
}
#endif