#include "SwArr16MOSFET.h"
const uint32_t SwArr16MOSFET::m_statearray[] = {
    ALLGND, CH01Lo, CH02Lo, CH03Lo, CH04Lo, CH05Lo, CH06Lo, CH07Lo, CH08Lo, 
    CH09Lo, CH10Lo, CH11Lo, CH12Lo, CH13Lo, CH14Lo, CH15Lo, CH16Lo, ALLHiZ
};
//  A constractor whose arguments have all default value
//  is a default constractor.
SwArr16MOSFET::SwArr16MOSFET():
    m_num_ch(16),
    m_SER(DigitalOut(p14)), //HV_DOIB   (14)(2)
    m_SCK(DigitalOut(p13)), //HV_BL     (13)(3)
    m_RCK(DigitalOut(p12)), //HV_POL    (12)(4)
    m_CLR(DigitalOut(p11)), //HV_CLK    (11)(7)
    m_MD_OE(DigitalOut(p10))//HV_LE     (10)(8)
{
    init();
}
SwArr16MOSFET::SwArr16MOSFET(
    uint8_t arg_num_ch
):
    m_num_ch(arg_num_ch),
    m_SER(DigitalOut(p14)), //HV_DOIB   (mbed-14)(JP1-2)
    m_SCK(DigitalOut(p13)), //HV_BL     (mbed-13)(JP1-3)
    m_RCK(DigitalOut(p12)), //HV_POL    (mbed-12)(JP1-4)
    m_CLR(DigitalOut(p11)), //HV_CLK    (mbed-11)(JP1-7)
    m_MD_OE(DigitalOut(p10))//HV_LE     (mbed-10)(JP1-8)
{
    init();
}

SwArr16MOSFET::SwArr16MOSFET(
    uint8_t arg_num_ch,
    PinName arg_SER,
    PinName arg_SCK,
    PinName arg_RCK,
    PinName arg_CLR,
    PinName arg_MD_OE
):
    m_num_ch(arg_num_ch),
    m_SER(DigitalOut(arg_SER)),
    m_SCK(DigitalOut(arg_SCK)),
    m_RCK(DigitalOut(arg_RCK)),
    m_CLR(DigitalOut(arg_CLR)),
    m_MD_OE(DigitalOut(arg_MD_OE))
{
    init();
}
//  ----------------------------------------------------------------------------
void SwArr16MOSFET::init()
{
    disable_HiZ();
    //reset shiftresister
    m_CLR = 0;
    update();
    
    //enable insertion data to SR
    m_CLR = 1;
    m_SCK = m_RCK = 0;
    
    allHiZ();
    m_mode = TWIN_ELECTRODES;
    m_POL = Cathodic;
}

void SwArr16MOSFET::allGround()
{
    if (m_state == ALLGND) return;
    disable_HiZ();
    sweep();
    upload();
    enable();
    m_state = ALLGND;
    m_pos_stim = 0;
}

void SwArr16MOSFET::allHiZ()
{
    disable_HiZ();
    if (m_state == ALLHiZ) return;
    setBits(ALLHiZ);
    upload();
    m_state = ALLHiZ;
    m_pos_stim = 0;
}
//  ----------------------------------------------------------------------------
void SwArr16MOSFET::setTwin(char arg_stim_ch, char arg_ref_ch)
{
    disable_HiZ();
    m_mode = TWIN_ELECTRODES;
    m_state = ((ALLHiZ & (~m_statearray[arg_stim_ch])) | m_statearray[arg_ref_ch]);
    setBits(m_state);
    upload();
    enable();
    m_pos_stim = arg_stim_ch;
}

void SwArr16MOSFET::setTrio(char arg_stim_ch, char arg_ref_ch1, char arg_ref_ch2)
{
    disable_HiZ();
    m_mode = TWIN_ELECTRODES;
    m_state = (ALLHiZ & (~m_statearray[arg_stim_ch])) 
        | m_statearray[arg_ref_ch1]
        | m_statearray[arg_ref_ch2];
    setBits(m_state);
    upload();
    enable();
    m_pos_stim = arg_stim_ch;
}

void SwArr16MOSFET::setOvsO(char arg_ch)
{
    int8_t num_of_shift;

    disable_HiZ();
    num_of_shift = arg_ch - m_pos_stim;
    //  m_mode == ONE_VS_THEOTHERS && m_pos_stim == 0
    //  => m_state == ALLGND
    if( num_of_shift < 0 || m_pos_stim == 0 || m_mode != ONE_VS_THEOTHERS) {
        sweep();
        setStimbits();
        num_of_shift = arg_ch - 1;
    }
    shiftby(num_of_shift);
    m_mode = ONE_VS_THEOTHERS;
    m_state = ALLGND & (~m_statearray[arg_ch]);

    upload();
    enable();
    m_pos_stim = arg_ch;
}

//  ----------------------------------------------------------------------------
//  For One vs the Other stimulation
void SwArr16MOSFET::sweep()
{
    uint32_t num_shift;

    if(m_mode != ONE_VS_THEOTHERS || m_state == ALLHiZ) {
        num_shift = m_num_ch;
    } else if(m_mode == ONE_VS_THEOTHERS) {
        num_shift = m_num_ch - (m_pos_stim - 1);
    }
    shiftby(num_shift);
}

void SwArr16MOSFET::shiftby(int arg_num)
{
    for(int i = 0; i < arg_num; i++) {
        //  insert 1 XOR Polarity
        m_SER = 1 ^ m_POL;
        update();
        //  insert 0 XOR Polarity
        m_SER = 1 ^ m_POL;
        update();
    }
}

void SwArr16MOSFET::setStimbits()
{
    //  insert 0 XOR Polarity
    m_SER = 0 ^ m_POL;
    update();
    //  insert 1 XOR Polarity
    m_SER = 0 ^ m_POL;
    update();
    m_state = CH01Lo;
}
//  For any stimulation

void SwArr16MOSFET::setBits(const uint32_t arg_bits)
{
    /*  arg_bits: 0b xx xx xx xx ... xx xx xx
     *          ch1 <-                     ->ch[m_num_ch]
     */
     
    uint8_t tmp_bit[2];
    for(int i = 16 - m_num_ch; i < 16; i++) {
        tmp_bit[0] = 0b01 & (arg_bits >> (2 * i));
        tmp_bit[1] = 0b01 & (arg_bits >> (2 * i + 1));
        //  if the channel is not HiZ but meaning Hi or Lo
        if(tmp_bit[0] ^ tmp_bit[1] == 0) {
            m_SER = (tmp_bit[0] ^ m_POL); //XOR Polarity
            update();
            m_SER = (tmp_bit[1] ^ m_POL); //XOR Polarity
            update();
        } else {//if HiZ, store them as is
            m_SER = (tmp_bit[0]);
            update();
            m_SER = (tmp_bit[1]);
            update();
        }
    }
}
//  ----------------------------------------------------------------------------
void SwArr16MOSFET::update()
{
    //Shift-resister Clock update
    m_SCK = 1;
    m_SCK = 1;
    m_SCK = 0;
    m_SCK = 0;
}
void SwArr16MOSFET::upload()
{
    //FF Clock Update
    m_RCK = 1;
    m_RCK = 1;
    m_RCK = 0;
    m_RCK = 0;
}
//  ----------------------------------------------------------------------------
void SwArr16MOSFET::disable_HiZ()
{
    m_MD_OE = 0;
}
void SwArr16MOSFET::enable()
{
    m_MD_OE = 1;
}