#include "mbed.h"
#include "StrCommandHandler.h"
#include "SerialInputReactionHandler.h"

DigitalOut myled1(LED1);

DigitalOut myled2(LED2);

DigitalOut myled3(LED3);

DigitalOut myled4(LED4);

Serial pc(USBTX, USBRX); // tx, rx

StrCommandHandler cmdHandler(5);


void * func1(void)
{
    myled1 = 1;
    myled2 = 0;
    myled3 = 0;
    return NULL;
}

void * func2(void)
{
    myled1 = 0;
    myled2 = 1;
    myled3 = 0;
    return NULL;
}

void * func3(void)
{
    myled1 = 0;
    myled2 = 0;
    myled3 = 1;
    return NULL;
}

int main()
{
    pc.baud(921600);
    cmdHandler.map("func1", func1);
    cmdHandler.map("func2", func2);
    cmdHandler.map(SerialInputReactionHandler::ARROW_UP, func3);
    cmdHandler.list();
    
    SerialInputReactionHandler *reactor = new SerialInputReactionHandler();
    //reactor->attach(callback(&cmdHandler, &StrCommandHandler::exe));
    //reactor.startReception(&pc, SerialInputReactionHandler::KB_TILL_ENTER);
    


PRELOOP:
    pc.puts("\ncommand: ");
    while(1) {
        myled4 = !myled4;
        wait(.5);
    }
    goto PRELOOP;
}