#ifndef STR_COMMAND_HANDLER_H
#define STR_COMMAND_HANDLER_H
#include "mbed.h"
#include <string>

/** Maps strings and functions
 *
 *  This class can map strings(commands) and functions receiving no arguments
 *  returning int.
 */
class StrCommandHandler
{
public:
    StrCommandHandler(
        int const arg_num_ofcommand = 10
    );

    /** Maps strings and functions
     *
     *  This maps strings(commands) and functions receiving own command,
     *  returning something of pointer.
     */
    void map(
        const char * const   arg_command,
        void * (*arg_pfunc)(const char * const)
    );

    /** Analyzes a command input and executs a function corresponding to it.
     *
     *  This analyzes a string(commands) and executs a corresponding function.
     *  If an error occur, the function returns an error code
     *  Error code:
     *  -   Exception of NULL pointer           returns 0xFFFFFFFF
     *  -   Exception of Null character         returna 0xFFFFFFFE
     *  -   Exception of Over length            returns 0xFFFFFFFD
     *  -   Exception of Not registered Command returns 0xFFFFFFFC;
     */
    void * exe(
        const char* const   arg_command
    );

    /** Lists commands registered
     *
     *  This lists commands registered by users. 
     */
    void list();
    
    
    static char const * const ARROW_UP;     /// ascii code series arrow-up symbol 0x1b 0x5b, 0x41
    static char const * const ARROW_DOWN;   /// ascii code series arrow-up symbol 0x1b 0x5b, 0x42
    static char const * const ARROW_RIGHT;  /// ascii code series arrow-up symbol 0x1b 0x5b, 0x43
    static char const * const ARROW_LEFT;   /// ascii code series arrow-up symbol 0x1b 0x5b, 0x44

private:
    /** Array of commands' name
     *
     *  The length should be within 15 without last '\0'
     *  The number of the array is (int)m_numofcommands
     */
    char (*m_command_name)[16];

    /** Array of pointers to functions
     *  
     *  The number of the array is (int)m_numofcommands
     */
    void * (**m_function)(const char * const);
    
    /** Numbers of commands registered in this.
     *
     *  If commands are registered over this value,
     *  this value increase by 5, and arrays get reallocated.
     */
    int m_num_ofcommands;
    
    /** Result code of exe()
     *  
     *  This is supposed to be offered by pointer
     */
    int m_rescode;
};
#endif