#ifndef SPHEREFITTING_H
#define SPHEREFITTING_H

#include <stdio.h>
#include <math.h>
#include <time.h>
#include <stdlib.h>

template<typename T>
struct Sphere {
public:
    Sphere(T cx = 0, T cy = 0, T cz = 0);
    T cx, cy, cz, r;
};


template<typename T>
class SphereFitting
{
public:
    SphereFitting(T cx = 0, T cy = 0, T cz = 0);
    ~SphereFitting();
    void solve();
    void addsample(T, T, T);
    void copy_param_to(T*, T*, T*, T*);
private:
    Sphere<T>* P;
    T X[4][4];
    T Y[4];
};
template class SphereFitting<short>;
template class SphereFitting<int>;
template class SphereFitting<float>;
#endif