#include "SerialInputReactionHandler.h"

SerialInputReactionHandler::SerialInputReactionHandler(
    Callback<void *(char const * const)> arg_callback_onCommand,
    Callback<void (char const * const)> arg_Pre_callback_onCommand,
    Callback<void (char const * const, void *)> arg_Post_callback_onCommand
)
{
    funcIfInput[KB_SINGLE_INPUT] = &SerialInputReactionHandler::listenKBSingleInput;
    funcIfInput[KB_TILL_ENTER] = &SerialInputReactionHandler::listenKBTillEnter;
    m_callback_onCommand = arg_callback_onCommand;
    m_Pre_callback_onCommand = arg_Pre_callback_onCommand;
    m_Post_callback_onCommand = arg_Post_callback_onCommand;
}



void SerialInputReactionHandler::attach(
    Callback<void * (char const * const)> arg_callback_onCommand
)
{
    m_callback_onCommand = arg_callback_onCommand;
}



void SerialInputReactionHandler::attach_PreProc(
    Callback<void (char const * const)> arg_Pre_callback_onCommand
)
{
    m_Pre_callback_onCommand = arg_Pre_callback_onCommand;
}



void SerialInputReactionHandler::attach_PostProc(
    Callback<void (char const * const, void *)> arg_Post_callback_onCommand
)
{
    m_Post_callback_onCommand = arg_Post_callback_onCommand;
}



void SerialInputReactionHandler::startReception(
    Serial * arg_serial_socket,
    InputMode arg_mode
)
{
    m_serial_socket = arg_serial_socket;
    m_input_mode = arg_mode;
    m_serial_socket->attach(callback(this, &SerialInputReactionHandler::sig_bind));
}



void SerialInputReactionHandler::quit()
{
    m_serial_socket->attach(NULL);
}



void SerialInputReactionHandler::sig_bind()
{
    (this->*funcIfInput[m_input_mode])();
}



void SerialInputReactionHandler::changeMode(InputMode arg_mode)
{
    discardBuffer();
    m_input_mode = arg_mode;
}



void SerialInputReactionHandler::callback_onCommand(char const * const arg_command)
{
    void * l_rescallback;
    m_Pre_callback_onCommand(arg_command);
    l_rescallback = m_callback_onCommand(arg_command);
    m_Post_callback_onCommand(arg_command, l_rescallback);
}



void SerialInputReactionHandler::listenKBSingleInput()
{
    m_buffer_c = m_serial_socket->getc();
    m_buffer_s = m_buffer_c;
    if(m_buffer_c != 0x1B || m_buffer_c == 0x1B && isArrowSymbol())
        callback_onCommand(m_buffer_s.c_str());
    discardBuffer();
}



bool SerialInputReactionHandler::isArrowSymbol()
{
    //  If only 0x1B, ESC KEY should be Pressed, else some symbol sequence.
    if (m_buffer_c == 0x1B && m_serial_socket->readable()) {
        m_buffer_s = m_buffer_c;
        m_buffer_c = m_serial_socket->getc();

        //  If 0x5B follows, it coul be arrow key was pressed
        if (m_buffer_c == 0x5B && m_serial_socket->readable()) {
            m_buffer_s += m_buffer_c;
            m_buffer_c = m_serial_socket->getc();
        } else m_buffer_c = 0x1B;

        m_buffer_s += m_buffer_c;
    } else m_buffer_c = 0x1B;

    if (m_buffer_c == 0x1B) return false;
    else return true;
}



void SerialInputReactionHandler::listenKBTillEnter()
{
    __disable_irq();
    m_buffer_c = m_serial_socket->getc();

    if ( isUpperCase(m_buffer_c) || isLowerCase(m_buffer_c) || isSymbol( m_buffer_c)) {

        if(m_buffer_s.length() != 0 && m_buffer_s[0] != '\0')
            m_buffer_s += m_buffer_c;
        else
            m_buffer_s = m_buffer_c;
        m_serial_socket->putc(m_buffer_c);

    } else if ( m_buffer_c == '\n' || m_buffer_c == '\r') {

        m_serial_socket->putc(m_buffer_c);
        callback_onCommand(m_buffer_s.c_str());
        discardBuffer();

    } else if (isArrowSymbol()) {

        //  Arrows
        callback_onCommand(m_buffer_s.c_str());
        discardBuffer();

    } else {
        switch (m_buffer_c) {
            case 0x08 /*BS */:
            case 0x7F /*DEL*/:
                m_buffer_s.erase(m_buffer_s.end() - 1);
                //m_serial_socket->putc(0x7F);
                m_serial_socket->putc(0x08);
                m_serial_socket->putc(0x20);
                m_serial_socket->putc(0x08);
                break;
            case 0x1B /*ESC*/:
                discardBuffer();
                break;

        }
    }
    __enable_irq();
}
