#ifndef KAJIMOTO_LAB_ELECTRIC_STIMULATION_H
#define KAJIMOTO_LAB_ELECTRIC_STIMULATION_H
#include "mbed.h"
/** \Class  KajiLabES nyaan
 *  The class which make the electrical stimulator device made by Ph.D Kajimoto
 *  out put sotimulation current and get impedance among electrodes.
 *
 */
class KajiLabES
{
private:
    //DAAD
    SPI         _spiDAAD;//(p5, p6, p7);   // mosi(master output slave input, miso(not connected), clock signal
    DigitalOut  _DA_sync;//(p8);           //chip select for AD5452
    DigitalOut  _AD_cs;//(p9);             //chip select for AD7276

public:
    //KajiLabES();
    KajiLabES(
        PinName mosi = p5,
        PinName miso = p6,
        PinName clk  = p7,
        PinName DA_sync = p8,
        PinName AD_cs   = p9);
    //~KajiLabES();

    /** Execute DA&AD at the same time
     *  \par    About DA & AD
     *  -   DA output electrical current using AD5452(SPI)
     *  -   AD input impedance using AD7276(SPI)
     */
    short DAAD(short DA);
    
    /// Initialize SPI setting
    /**
     *  DA & AD devices are controlled by SPI.
     *  In this procedure, SPI are configurated as following
     *  -   buffer bit: 16 bit
     *  -   SPI Mode:   2
     *  -   Frequency:  48000000 Hz
     *
     *  \par About SPI Mode
     *  SPI has 4 modes
     *      \verbatim
     *      |Mode       |Polarity   |Phase      |
     *      |:---------:|:---------:|:---------:|
     *      |0          |0          |0          |
     *      |1          |0          |1          |
     *      |2          |1          |0          |
     *      |3          |1          |1          |
     *      \endverbatim
     *  .
     */
    void init();
};
#endif