#include "KajiLabES.h"
/*
KajiLabES::KajiLabES():
    _spiDAAD(SPI(p5, p6, p7)),   // mosi(master output slave input, miso(not connected), clock signal
    _DA_sync(DigitalOut(p8)),           //chip select for AD5452
    _AD_cs(DigitalOut(p9))
{}
*/
KajiLabES::KajiLabES(
    PinName mosi,
    PinName miso,
    PinName clk ,
    PinName DA_sync,
    PinName AD_cs
):
    _spiDAAD(SPI(mosi,miso,clk)),//(p5, p6, p7);   // mosi(master output slave input, miso(not connected), clock signal
    _DA_sync(DigitalOut(DA_sync)),//(p8);           //chip select for AD5452
    _AD_cs(DigitalOut(AD_cs))//(p9);
{}
//KajiLabES::~KajiLabES(){}

//  DA&AD at the same time
//  DA output by AD5452(SPI)
//  AD input by AD7276(SPI)
short KajiLabES::DAAD(short DA)
{
    short AD;

    //enable
    _DA_sync = 0;
    _AD_cs = 0;
    //simultaneous DA and AD
    AD = _spiDAAD.write(DA<<2);
    //disable
    _DA_sync = 1;
    _AD_cs = 1;

    //return the impedance scanned last. bottom 2bits are unnecessary
    return AD>>2;
}
void KajiLabES::init()
{
    //Setup SPI, 16bit, falling edge, 48MHz clock
    _spiDAAD.format(16, 2);
    //_spiDAAD.format(16, 1);
    _spiDAAD.frequency(48000000);
}