#ifndef SUBROUTINES_H
#define SUBROUTINES_H

#include "mbed.h"

extern DigitalOut  myled1;
extern DigitalOut  myled2;
extern DigitalOut  myled3;
extern DigitalOut  myled4;

enum ProcessState {WAIT_A_CERTAIN_KEY, MAIN_ROUTINE, TERMINATED};
extern ProcessState   pstate;

//  prototype

/// Called in main 
void init(void);

/// Called when it attached to ticker
void loop(void);


void * printKBManual(void);
void * printStatus(void);
void * printDSinSamples(void);

void * increaseCurrent(void);
void * decreaseCurrent(void);
void * increaseFrequency(void);
void * decreaseFrequency(void);

void * beginParamsSetting(void);
void * SetAmplitude(char const * const);
void * SetFrequency(char const * const);
void * endParamsSetting(void);

void * switchState();
void * startLoop(void);
void * pauseLoop(void);
void * terminateLoop(void);

void calleddefault(char const * const, void *);
#endif