//HTTP_SERVER.h
#ifndef HTTP_SERVER_H
#define HTTP_SERVER_H
#include "mbed.h"
#include "EthernetInterface.h"
#include "ResponseMessenger.h"
#include "FileHandler.h"
#include "string.h"
#include "filetest.h"
#include <stdlib.h>
using namespace std;

enum PortNum {
     TCP_PORT = 80,
};
/** HttpServer class
 *
 * This is the class to make a mbed a simple HTTP Server.
 */
class HttpServer
{
public:
    HttpServer();
    ~HttpServer();
    /** HTTP SERVER Initialization.
     *
     *  This function should be called first of all.
     *  @return result of init() as boolean.
     *  @retval TRUE SACCESS
     *  @retval FALSE
     */
    bool init();
    /** Run the surver service while listening flag is true.
     *
     *  @return state ending.
     *  @retval TRUE at error end.
     *  @retval FALSE at normal end.
     */
    bool run();

private:
    //  Handlers
    NetworkInterface    *net;    //  Eternet/Wifi
    TCPSocket           client_socket;  //  TCP server connection clerk
    SocketAddress       client_address; //  Address of client
    TCPServer           server; //  TCP server
    ResponseMessenger   msger;  //  Handler of Messenge for a client
    FileHandler         fhndl;  //  File Handler
    //  Param
    //bool keep_alive;
    bool listening_flag;
    bool socket_connection;
    uint16_t port;     //Port number
    int backlog;           //backlog Number of pending connections that can be queued simultaneously
    //  Function
    bool analyzeRequest(char*,int,char*&,char*&,char*&);
    bool sendResponse(char*,char*,char*);
 
};

#endif