/*  ResponseMessenger.h */
#ifndef RESPONSE_MESSENGER_H
#define RESPONSE_MESSENGER_H
#include "mbed.h"
#include "string.h"
#include "EthernetInterface.h"
#include "FileHandler.h"
#include <stdlib.h>
using namespace std;

class ResponseMessenger
{
    enum {
        REASON_PHRASE_SIZE = 32,
        HEADER_FIELDS_SIZE = 2048
    };
public:
    ResponseMessenger();
    ~ResponseMessenger();
    int resetHeader();
    int setStatusLine(int,const char*);
    int setHeaderField(const char*, const char*);
    int setHeaderField(const char*, int);
    int rmHeaderField(const char*);
    int getStatusCode();
    /**
     *  Function to send response messages.
     *  just header only
     *  @return char
     *  @retval error code
     */
    char sendHTTPResponse(TCPSocket&);
    /**
     *  Function to send response messages.
     *  @return char
     *  @retval error code
     */
    char sendHTTPResponse(TCPSocket&, FileHandler&);
private:
    //  Status-Line
    static const char http_ver[9];
    int  status_code;
    char reason_phrase[REASON_PHRASE_SIZE];
    //  Header Field buffer
    //  - General Header
    //  - Response Header
    //  - Entity Header
    char header_field_buffer[HEADER_FIELDS_SIZE];
};

#endif