#include "FileHandler.h"
//#ifndef DEBUG
#define FILE_HANDLER_DEBUG
//#endif
LocalFileSystem local("local");

namespace FILE_HANDLER
{
void DEBUG_PRINT_NAME()
{
#ifdef FILE_HANDLER_DEBUG
    printf("(DEBUG LINE: FILE_HANDLER) ");
#endif
}

void DEBUG_PRINT_LINE(const char* arg_line)
{
#ifdef FILE_HANDLER_DEBUG
    DEBUG_PRINT_NAME();
    printf(arg_line);
    printf("\r\n");
#endif
}
template<typename T>
void DEBUG_PRINT_LINE(const char* arg_line, T arg_t)
{
#ifdef FILE_HANDLER_DEBUG
    DEBUG_PRINT_NAME();
    printf(arg_line, arg_t);
    printf("\r\n");
#endif
}
template<typename T1, typename T2>
void DEBUG_PRINT_LINE(const char* arg_line, T1 arg_t1, T2 arg_t2)
{
#ifdef FILE_HANDLER_DEBUG
    DEBUG_PRINT_NAME();
    printf(arg_line, arg_t1, arg_t2);
    printf("\r\n");
#endif
}
}
using namespace FILE_HANDLER;

FileHandler::FileHandler()
{
    fullpath = NULL;
    filename = NULL;
    suffix = NULL;
    fp = NULL;
    file_size = 0;
}
FileHandler::~FileHandler()
{
    if (fullpath != NULL) free(fullpath);
    if (fp != NULL) fclose(fp);
}

FILE* FileHandler::open
(   const char* arg_filepath,
    const char* arg_mode
)
{
    FILE *tmp;

    DEBUG_PRINT_LINE("fp: %d", fp);
    if (fullpath != NULL) free(fullpath);
    //  Allocating memory for fullpath;
    //  [[+ strlen("index.htm") + 1]] at the end of line is ONLY a MARGIN allowed for concatenating the string.
    fullpath = (char*)malloc(sizeof(char) * (strlen("/local/") + strlen(arg_filepath) + strlen("index.htm") + 1));

    //  Path formatting
    if (arg_filepath[0] == '/') {
        sprintf(fullpath, "/local/%s", arg_filepath + 1);
    } else {
        sprintf(fullpath, "/local/%s", arg_filepath);
    }
    //  if the argument has no file name but directory, defalt settiing.
    if (fullpath[strlen(fullpath) - 1] == '/')
        strcat(fullpath, "index.htm");
    DEBUG_PRINT_LINE("full-file-path: %s", fullpath);
    //  store the file name part into a pointer
    filename = strrchr(fullpath, '/');
    //  remove '/' and just get only the file name.
    if(filename != NULL)    filename++;
    //  store the suffix part to a pointer
    suffix = strchr(filename, '.');
    //  remove '.' and just get only the suffix.
    if(suffix   != NULL)    suffix++;
    DEBUG_PRINT_LINE("!!Public function check...");
    DEBUG_PRINT_LINE("  full path: %s", getFullpath());
    DEBUG_PRINT_LINE("  filename : %s", getFilename());
    DEBUG_PRINT_LINE("  suffix   : %s", getSuffix());
    DEBUG_PRINT_LINE("...DONE!!");
    DEBUG_PRINT_LINE("fopen(...)");
    DEBUG_PRINT_LINE("  path: %s", fullpath);
    DEBUG_PRINT_LINE("  mode: %s", arg_mode);
    fp = fopen(fullpath, arg_mode);
    if(fp != NULL) {
        DEBUG_PRINT_LINE("file opened");
        DEBUG_PRINT_LINE("fp: %d", fp);
    } else {
        DEBUG_PRINT_LINE("Something is wrong @fopen(...)");
    }
    //  mesure file size
    file_size = 0;
    tmp = fp;
    if(tmp != NULL ) {
        ////printf("\r\nfile content\r\n");
        int ctmp;
        while(1) {
            ctmp = fgetc(tmp);
            if(ctmp != EOF) {
                //////printf("%c", ctmp);
                file_size++;
            } else {
                //////printf("[EOF]\r\n");
                break;
            }
        }
        ////printf("file size: %d\r\n", file_size);
        if(fseek(tmp, 0L, SEEK_SET) != 0) {
            //////printf("fseek failed\r\n");
        }
    } else {
        file_size = 0;
    }

    return fp;
}
int FileHandler::close()
{
    int tmp;

    if(fp != NULL) {
        tmp = fclose(fp);
        fp = NULL;
        return tmp;
    } else {
        return 1;
    }
}

int FileHandler::getc()
{
    int tmp = fgetc(fp);
#ifdef DEBUG
    if(0x20 < tmp && tmp < 0x7e)
        printf("%c", tmp);
    else if (tmp == '\r')
        printf("\r");
    else if (tmp == '\n')
        printf("\n");
    else
        printf("@");
#endif
    return tmp;
}
bool FileHandler::arrival()
{
    return (bool)fp;
}
bool FileHandler::atEOF()
{
    return (bool)feof(fp);
}
bool FileHandler::hasError()
{
    return (bool)ferror(fp);
}
char *FileHandler::getFullpath()
{
    return fullpath;
}
char *FileHandler::getFilename()
{
    return filename;
}
char *FileHandler::getSuffix()
{
    return suffix;
}
int FileHandler::getFileSize()
{
    return file_size;
}