//HTTP_SERVER.h
#ifndef HTTP_SERVER_H
#define HTTP_SERVER_H
#include "mbed.h"
#include "EthernetInterface.h"
#include "ResponseMessenger.h"
#include "FileHandler.h"
#include "string.h"
#include <stdlib.h>
using namespace std;

enum PortNum {
    TCP_PORT = 80
};
/** HttpServer class
 *
 * This is the class to make a mbed a simple HTTP Server.
 */
class HttpServer
{
public:
    HttpServer();
    ~HttpServer();
    /** HTTP SERVER Initialization.
     *
     *  This function should be called first of all.
     *  @return result of init() as boolean.
     *  @retval TRUE SACCESS
     *  @retval FALSE
     */
    bool init();
    /** Run the surver service while listening flag is true.
     *
     *  @return state ending.
     *  @retval TRUE at error end.
     *  @retval FALSE at normal end.
     */
    bool run();

private:
    //  Handlers
    EthernetInterface   eth;    //  Eternet
    TCPSocketServer     tcpsvr; //  TCP server
    TCPSocketConnection tcpcon; //  TCP server connection clerk
    ResponseMessenger   msger;  //  Messenger for a client
    FileHandler         fhandl; //
    //  Param
    bool keep_alive;
    bool listening_flag;
    char req_buf[1024];
};

#endif